// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.RegistryPassword;
import java.io.IOException;
import java.util.List;

/**
 * The response from the ListCredentials operation.
 */
@Fluent
public final class RegistryListCredentialsResultInner implements JsonSerializable<RegistryListCredentialsResultInner> {
    /*
     * The username for a container registry.
     */
    private String username;

    /*
     * The list of passwords for a container registry.
     */
    private List<RegistryPassword> passwords;

    /**
     * Creates an instance of RegistryListCredentialsResultInner class.
     */
    public RegistryListCredentialsResultInner() {
    }

    /**
     * Get the username property: The username for a container registry.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username for a container registry.
     * 
     * @param username the username value to set.
     * @return the RegistryListCredentialsResultInner object itself.
     */
    public RegistryListCredentialsResultInner withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the passwords property: The list of passwords for a container registry.
     * 
     * @return the passwords value.
     */
    public List<RegistryPassword> passwords() {
        return this.passwords;
    }

    /**
     * Set the passwords property: The list of passwords for a container registry.
     * 
     * @param passwords the passwords value to set.
     * @return the RegistryListCredentialsResultInner object itself.
     */
    public RegistryListCredentialsResultInner withPasswords(List<RegistryPassword> passwords) {
        this.passwords = passwords;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (passwords() != null) {
            passwords().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeArrayField("passwords", this.passwords, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegistryListCredentialsResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegistryListCredentialsResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegistryListCredentialsResultInner.
     */
    public static RegistryListCredentialsResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistryListCredentialsResultInner deserializedRegistryListCredentialsResultInner
                = new RegistryListCredentialsResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("username".equals(fieldName)) {
                    deserializedRegistryListCredentialsResultInner.username = reader.getString();
                } else if ("passwords".equals(fieldName)) {
                    List<RegistryPassword> passwords = reader.readArray(reader1 -> RegistryPassword.fromJson(reader1));
                    deserializedRegistryListCredentialsResultInner.passwords = passwords;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegistryListCredentialsResultInner;
        });
    }
}
