// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.TokenCredentialsProperties;
import com.azure.resourcemanager.containerregistry.models.TokenStatus;
import java.io.IOException;

/**
 * The parameters for updating token properties.
 */
@Fluent
public final class TokenUpdateProperties implements JsonSerializable<TokenUpdateProperties> {
    /*
     * The resource ID of the scope map to which the token will be associated with.
     */
    private String scopeMapId;

    /*
     * The status of the token example enabled or disabled.
     */
    private TokenStatus status;

    /*
     * The credentials that can be used for authenticating the token.
     */
    private TokenCredentialsProperties credentials;

    /**
     * Creates an instance of TokenUpdateProperties class.
     */
    public TokenUpdateProperties() {
    }

    /**
     * Get the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     * 
     * @return the scopeMapId value.
     */
    public String scopeMapId() {
        return this.scopeMapId;
    }

    /**
     * Set the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     * 
     * @param scopeMapId the scopeMapId value to set.
     * @return the TokenUpdateProperties object itself.
     */
    public TokenUpdateProperties withScopeMapId(String scopeMapId) {
        this.scopeMapId = scopeMapId;
        return this;
    }

    /**
     * Get the status property: The status of the token example enabled or disabled.
     * 
     * @return the status value.
     */
    public TokenStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the token example enabled or disabled.
     * 
     * @param status the status value to set.
     * @return the TokenUpdateProperties object itself.
     */
    public TokenUpdateProperties withStatus(TokenStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the credentials property: The credentials that can be used for authenticating the token.
     * 
     * @return the credentials value.
     */
    public TokenCredentialsProperties credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: The credentials that can be used for authenticating the token.
     * 
     * @param credentials the credentials value to set.
     * @return the TokenUpdateProperties object itself.
     */
    public TokenUpdateProperties withCredentials(TokenCredentialsProperties credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (credentials() != null) {
            credentials().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scopeMapId", this.scopeMapId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("credentials", this.credentials);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenUpdateProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TokenUpdateProperties.
     */
    public static TokenUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenUpdateProperties deserializedTokenUpdateProperties = new TokenUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scopeMapId".equals(fieldName)) {
                    deserializedTokenUpdateProperties.scopeMapId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedTokenUpdateProperties.status = TokenStatus.fromString(reader.getString());
                } else if ("credentials".equals(fieldName)) {
                    deserializedTokenUpdateProperties.credentials = TokenCredentialsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenUpdateProperties;
        });
    }
}
