// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.AgentPoolPropertiesUpdateParameters;
import java.io.IOException;
import java.util.Map;

/**
 * The parameters for updating an agent pool.
 */
@Fluent
public final class AgentPoolUpdateParameters implements JsonSerializable<AgentPoolUpdateParameters> {
    /*
     * The properties associated with the agent pool
     */
    private AgentPoolPropertiesUpdateParameters innerProperties;

    /*
     * The ARM resource tags.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of AgentPoolUpdateParameters class.
     */
    public AgentPoolUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The properties associated with the agent pool.
     * 
     * @return the innerProperties value.
     */
    private AgentPoolPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: The ARM resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The ARM resource tags.
     * 
     * @param tags the tags value to set.
     * @return the AgentPoolUpdateParameters object itself.
     */
    public AgentPoolUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the count property: The count of agent machine.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.innerProperties() == null ? null : this.innerProperties().count();
    }

    /**
     * Set the count property: The count of agent machine.
     * 
     * @param count the count value to set.
     * @return the AgentPoolUpdateParameters object itself.
     */
    public AgentPoolUpdateParameters withCount(Integer count) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolPropertiesUpdateParameters();
        }
        this.innerProperties().withCount(count);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolUpdateParameters.
     */
    public static AgentPoolUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolUpdateParameters deserializedAgentPoolUpdateParameters = new AgentPoolUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolUpdateParameters.innerProperties
                        = AgentPoolPropertiesUpdateParameters.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAgentPoolUpdateParameters.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolUpdateParameters;
        });
    }
}
