// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ConnectedRegistryInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of a request to list connected registries for a container registry.
 */
@Fluent
public final class ConnectedRegistryListResult implements JsonSerializable<ConnectedRegistryListResult> {
    /*
     * The list of connected registries. Since this list may be incomplete, the nextLink field should be used to request
     * the next list of connected registries.
     */
    private List<ConnectedRegistryInner> value;

    /*
     * The URI that can be used to request the next list of connected registries.
     */
    private String nextLink;

    /**
     * Creates an instance of ConnectedRegistryListResult class.
     */
    public ConnectedRegistryListResult() {
    }

    /**
     * Get the value property: The list of connected registries. Since this list may be incomplete, the nextLink field
     * should be used to request the next list of connected registries.
     * 
     * @return the value value.
     */
    public List<ConnectedRegistryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of connected registries. Since this list may be incomplete, the nextLink field
     * should be used to request the next list of connected registries.
     * 
     * @param value the value value to set.
     * @return the ConnectedRegistryListResult object itself.
     */
    public ConnectedRegistryListResult withValue(List<ConnectedRegistryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next list of connected registries.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next list of connected registries.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ConnectedRegistryListResult object itself.
     */
    public ConnectedRegistryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedRegistryListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedRegistryListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectedRegistryListResult.
     */
    public static ConnectedRegistryListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedRegistryListResult deserializedConnectedRegistryListResult = new ConnectedRegistryListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ConnectedRegistryInner> value
                        = reader.readArray(reader1 -> ConnectedRegistryInner.fromJson(reader1));
                    deserializedConnectedRegistryListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedConnectedRegistryListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedRegistryListResult;
        });
    }
}
