// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The EncryptionProperty model.
 */
@Fluent
public final class EncryptionProperty implements JsonSerializable<EncryptionProperty> {
    /*
     * Indicates whether or not the encryption is enabled for container registry.
     */
    private EncryptionStatus status;

    /*
     * Key vault properties.
     */
    private KeyVaultProperties keyVaultProperties;

    /**
     * Creates an instance of EncryptionProperty class.
     */
    public EncryptionProperty() {
    }

    /**
     * Get the status property: Indicates whether or not the encryption is enabled for container registry.
     * 
     * @return the status value.
     */
    public EncryptionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Indicates whether or not the encryption is enabled for container registry.
     * 
     * @param status the status value to set.
     * @return the EncryptionProperty object itself.
     */
    public EncryptionProperty withStatus(EncryptionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the keyVaultProperties property: Key vault properties.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: Key vault properties.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the EncryptionProperty object itself.
     */
    public EncryptionProperty withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("keyVaultProperties", this.keyVaultProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionProperty if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionProperty.
     */
    public static EncryptionProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionProperty deserializedEncryptionProperty = new EncryptionProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedEncryptionProperty.status = EncryptionStatus.fromString(reader.getString());
                } else if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionProperty.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionProperty;
        });
    }
}
