// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties of a task step.
 */
@Fluent
public final class FileTaskStep extends TaskStepProperties {
    /*
     * The type of the step.
     */
    private StepType type = StepType.FILE_TASK;

    /*
     * The task template/definition file path relative to the source context.
     */
    private String taskFilePath;

    /*
     * The task values/parameters file path relative to the source context.
     */
    private String valuesFilePath;

    /*
     * The collection of overridable values that can be passed when running a task.
     */
    private List<SetValue> values;

    /**
     * Creates an instance of FileTaskStep class.
     */
    public FileTaskStep() {
    }

    /**
     * Get the type property: The type of the step.
     * 
     * @return the type value.
     */
    @Override
    public StepType type() {
        return this.type;
    }

    /**
     * Get the taskFilePath property: The task template/definition file path relative to the source context.
     * 
     * @return the taskFilePath value.
     */
    public String taskFilePath() {
        return this.taskFilePath;
    }

    /**
     * Set the taskFilePath property: The task template/definition file path relative to the source context.
     * 
     * @param taskFilePath the taskFilePath value to set.
     * @return the FileTaskStep object itself.
     */
    public FileTaskStep withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    /**
     * Get the valuesFilePath property: The task values/parameters file path relative to the source context.
     * 
     * @return the valuesFilePath value.
     */
    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    /**
     * Set the valuesFilePath property: The task values/parameters file path relative to the source context.
     * 
     * @param valuesFilePath the valuesFilePath value to set.
     * @return the FileTaskStep object itself.
     */
    public FileTaskStep withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    /**
     * Get the values property: The collection of overridable values that can be passed when running a task.
     * 
     * @return the values value.
     */
    public List<SetValue> values() {
        return this.values;
    }

    /**
     * Set the values property: The collection of overridable values that can be passed when running a task.
     * 
     * @param values the values value to set.
     * @return the FileTaskStep object itself.
     */
    public FileTaskStep withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FileTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FileTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (taskFilePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property taskFilePath in model FileTaskStep"));
        }
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
        if (baseImageDependencies() != null) {
            baseImageDependencies().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FileTaskStep.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", contextPath());
        jsonWriter.writeStringField("contextAccessToken", contextAccessToken());
        jsonWriter.writeStringField("taskFilePath", this.taskFilePath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valuesFilePath", this.valuesFilePath);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileTaskStep from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileTaskStep if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FileTaskStep.
     */
    public static FileTaskStep fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileTaskStep deserializedFileTaskStep = new FileTaskStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseImageDependencies".equals(fieldName)) {
                    List<BaseImageDependency> baseImageDependencies
                        = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    deserializedFileTaskStep.withBaseImageDependencies(baseImageDependencies);
                } else if ("contextPath".equals(fieldName)) {
                    deserializedFileTaskStep.withContextPath(reader.getString());
                } else if ("contextAccessToken".equals(fieldName)) {
                    deserializedFileTaskStep.withContextAccessToken(reader.getString());
                } else if ("taskFilePath".equals(fieldName)) {
                    deserializedFileTaskStep.taskFilePath = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedFileTaskStep.type = StepType.fromString(reader.getString());
                } else if ("valuesFilePath".equals(fieldName)) {
                    deserializedFileTaskStep.valuesFilePath = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<SetValue> values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    deserializedFileTaskStep.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileTaskStep;
        });
    }
}
