// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties for updating a timer trigger.
 */
@Fluent
public final class TimerTriggerUpdateParameters implements JsonSerializable<TimerTriggerUpdateParameters> {
    /*
     * The CRON expression for the task schedule
     */
    private String schedule;

    /*
     * The current status of trigger.
     */
    private TriggerStatus status;

    /*
     * The name of the trigger.
     */
    private String name;

    /**
     * Creates an instance of TimerTriggerUpdateParameters class.
     */
    public TimerTriggerUpdateParameters() {
    }

    /**
     * Get the schedule property: The CRON expression for the task schedule.
     * 
     * @return the schedule value.
     */
    public String schedule() {
        return this.schedule;
    }

    /**
     * Set the schedule property: The CRON expression for the task schedule.
     * 
     * @param schedule the schedule value to set.
     * @return the TimerTriggerUpdateParameters object itself.
     */
    public TimerTriggerUpdateParameters withSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    /**
     * Get the status property: The current status of trigger.
     * 
     * @return the status value.
     */
    public TriggerStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of trigger.
     * 
     * @param status the status value to set.
     * @return the TimerTriggerUpdateParameters object itself.
     */
    public TimerTriggerUpdateParameters withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the name property: The name of the trigger.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the trigger.
     * 
     * @param name the name value to set.
     * @return the TimerTriggerUpdateParameters object itself.
     */
    public TimerTriggerUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model TimerTriggerUpdateParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TimerTriggerUpdateParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("schedule", this.schedule);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimerTriggerUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimerTriggerUpdateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TimerTriggerUpdateParameters.
     */
    public static TimerTriggerUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimerTriggerUpdateParameters deserializedTimerTriggerUpdateParameters = new TimerTriggerUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedTimerTriggerUpdateParameters.name = reader.getString();
                } else if ("schedule".equals(fieldName)) {
                    deserializedTimerTriggerUpdateParameters.schedule = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedTimerTriggerUpdateParameters.status = TriggerStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimerTriggerUpdateParameters;
        });
    }
}
