// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The content trust policy for a container registry.
 */
@Fluent
public final class TrustPolicy implements JsonSerializable<TrustPolicy> {
    /*
     * The type of trust policy.
     */
    private TrustPolicyType type;

    /*
     * The value that indicates whether the policy is enabled or not.
     */
    private PolicyStatus status;

    /**
     * Creates an instance of TrustPolicy class.
     */
    public TrustPolicy() {
    }

    /**
     * Get the type property: The type of trust policy.
     * 
     * @return the type value.
     */
    public TrustPolicyType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of trust policy.
     * 
     * @param type the type value to set.
     * @return the TrustPolicy object itself.
     */
    public TrustPolicy withType(TrustPolicyType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the status property: The value that indicates whether the policy is enabled or not.
     * 
     * @return the status value.
     */
    public PolicyStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The value that indicates whether the policy is enabled or not.
     * 
     * @param status the status value to set.
     * @return the TrustPolicy object itself.
     */
    public TrustPolicy withStatus(PolicyStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrustPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrustPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TrustPolicy.
     */
    public static TrustPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrustPolicy deserializedTrustPolicy = new TrustPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedTrustPolicy.type = TrustPolicyType.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedTrustPolicy.status = PolicyStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrustPolicy;
        });
    }
}
