// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerregistry.fluent.ConnectedRegistriesClient;
import com.azure.resourcemanager.containerregistry.fluent.models.ConnectedRegistryInner;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryListResult;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ConnectedRegistriesClient.
 */
public final class ConnectedRegistriesClientImpl implements ConnectedRegistriesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ConnectedRegistriesService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of ConnectedRegistriesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ConnectedRegistriesClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = RestProxy.create(ConnectedRegistriesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerRegistryManagementClientConnectedRegistries to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerRegistryMan")
    public interface ConnectedRegistriesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ConnectedRegistryInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("registryName") String registryName,
            @PathParam("connectedRegistryName") String connectedRegistryName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("registryName") String registryName,
            @PathParam("connectedRegistryName") String connectedRegistryName,
            @BodyParam("application/json") ConnectedRegistryInner connectedRegistryCreateParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("registryName") String registryName,
            @PathParam("connectedRegistryName") String connectedRegistryName,
            @BodyParam("application/json") ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("registryName") String registryName,
            @PathParam("connectedRegistryName") String connectedRegistryName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ConnectedRegistryListResult>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("registryName") String registryName,
            @QueryParam("$filter") String filter, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/connectedRegistries/{connectedRegistryName}/deactivate")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deactivate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("registryName") String registryName,
            @PathParam("connectedRegistryName") String connectedRegistryName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ConnectedRegistryListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets the properties of the connected registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the connected registry along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ConnectedRegistryInner>> getWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, registryName, connectedRegistryName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the properties of the connected registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the connected registry along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ConnectedRegistryInner>> getWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            registryName, connectedRegistryName, accept, context);
    }

    /**
     * Gets the properties of the connected registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the connected registry on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConnectedRegistryInner> getAsync(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        return getWithResponseAsync(resourceGroupName, registryName, connectedRegistryName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the properties of the connected registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the connected registry along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ConnectedRegistryInner> getWithResponse(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        return getWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, context).block();
    }

    /**
     * Gets the properties of the connected registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the connected registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectedRegistryInner get(String resourceGroupName, String registryName, String connectedRegistryName) {
        return getWithResponse(resourceGroupName, registryName, connectedRegistryName, Context.NONE).getValue();
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryCreateParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter connectedRegistryCreateParameters is required and cannot be null."));
        } else {
            connectedRegistryCreateParameters.validate();
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName,
                connectedRegistryCreateParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryCreateParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter connectedRegistryCreateParameters is required and cannot be null."));
        } else {
            connectedRegistryCreateParameters.validate();
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            registryName, connectedRegistryName, connectedRegistryCreateParameters, accept, context);
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreateAsync(
        String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryInner connectedRegistryCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createWithResponseAsync(resourceGroupName, registryName,
            connectedRegistryName, connectedRegistryCreateParameters);
        return this.client.<ConnectedRegistryInner, ConnectedRegistryInner>getLroResult(mono,
            this.client.getHttpPipeline(), ConnectedRegistryInner.class, ConnectedRegistryInner.class,
            this.client.getContext());
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreateAsync(
        String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createWithResponseAsync(resourceGroupName, registryName,
            connectedRegistryName, connectedRegistryCreateParameters, context);
        return this.client.<ConnectedRegistryInner, ConnectedRegistryInner>getLroResult(mono,
            this.client.getHttpPipeline(), ConnectedRegistryInner.class, ConnectedRegistryInner.class, context);
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreate(String resourceGroupName,
        String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        return this
            .beginCreateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters)
            .getSyncPoller();
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginCreate(String resourceGroupName,
        String registryName, String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters,
        Context context) {
        return this
            .beginCreateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters,
                context)
            .getSyncPoller();
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConnectedRegistryInner> createAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters) {
        return beginCreateAsync(resourceGroupName, registryName, connectedRegistryName,
            connectedRegistryCreateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ConnectedRegistryInner> createAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        return beginCreateAsync(resourceGroupName, registryName, connectedRegistryName,
            connectedRegistryCreateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectedRegistryInner create(String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryInner connectedRegistryCreateParameters) {
        return createAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters)
            .block();
    }

    /**
     * Creates a connected registry for a container registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryCreateParameters The parameters for creating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectedRegistryInner create(String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryInner connectedRegistryCreateParameters, Context context) {
        return createAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryCreateParameters,
            context).block();
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryUpdateParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter connectedRegistryUpdateParameters is required and cannot be null."));
        } else {
            connectedRegistryUpdateParameters.validate();
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, registryName, connectedRegistryName,
                connectedRegistryUpdateParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        if (connectedRegistryUpdateParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter connectedRegistryUpdateParameters is required and cannot be null."));
        } else {
            connectedRegistryUpdateParameters.validate();
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            registryName, connectedRegistryName, connectedRegistryUpdateParameters, accept, context);
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdateAsync(
        String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, registryName,
            connectedRegistryName, connectedRegistryUpdateParameters);
        return this.client.<ConnectedRegistryInner, ConnectedRegistryInner>getLroResult(mono,
            this.client.getHttpPipeline(), ConnectedRegistryInner.class, ConnectedRegistryInner.class,
            this.client.getContext());
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdateAsync(
        String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, registryName,
            connectedRegistryName, connectedRegistryUpdateParameters, context);
        return this.client.<ConnectedRegistryInner, ConnectedRegistryInner>getLroResult(mono,
            this.client.getHttpPipeline(), ConnectedRegistryInner.class, ConnectedRegistryInner.class, context);
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdate(String resourceGroupName,
        String registryName, String connectedRegistryName,
        ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        return this
            .beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters)
            .getSyncPoller();
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an object that represents a connected registry for a container
     * registry.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConnectedRegistryInner>, ConnectedRegistryInner> beginUpdate(String resourceGroupName,
        String registryName, String connectedRegistryName,
        ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters,
                context)
            .getSyncPoller();
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ConnectedRegistryInner> updateAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        return beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName,
            connectedRegistryUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ConnectedRegistryInner> updateAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters,
        Context context) {
        return beginUpdateAsync(resourceGroupName, registryName, connectedRegistryName,
            connectedRegistryUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectedRegistryInner update(String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters) {
        return updateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters)
            .block();
    }

    /**
     * Updates a connected registry with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param connectedRegistryUpdateParameters The parameters for updating a connectedRegistry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a connected registry for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ConnectedRegistryInner update(String resourceGroupName, String registryName, String connectedRegistryName,
        ConnectedRegistryUpdateParameters connectedRegistryUpdateParameters, Context context) {
        return updateAsync(resourceGroupName, registryName, connectedRegistryName, connectedRegistryUpdateParameters,
            context).block();
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                    resourceGroupName, registryName, connectedRegistryName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            registryName, connectedRegistryName, accept, context);
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, registryName, connectedRegistryName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName).getSyncPoller();
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName, context).getSyncPoller();
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        return beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String connectedRegistryName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, registryName, connectedRegistryName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String connectedRegistryName) {
        deleteAsync(resourceGroupName, registryName, connectedRegistryName).block();
    }

    /**
     * Deletes a connected registry from a container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String connectedRegistryName, Context context) {
        deleteAsync(resourceGroupName, registryName, connectedRegistryName, context).block();
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param filter An OData filter expression that describes a subset of connectedRegistries to return. The parameters
     * that can be filtered are parent.id (the resource id of the connectedRegistry parent), mode, and connectionState.
     * The supported operator is eq.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listSinglePageAsync(String resourceGroupName,
        String registryName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, registryName, filter, accept, context))
            .<PagedResponse<ConnectedRegistryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param filter An OData filter expression that describes a subset of connectedRegistries to return. The parameters
     * that can be filtered are parent.id (the resource id of the connectedRegistry parent), mode, and connectionState.
     * The supported operator is eq.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listSinglePageAsync(String resourceGroupName,
        String registryName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
                registryName, filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param filter An OData filter expression that describes a subset of connectedRegistries to return. The parameters
     * that can be filtered are parent.id (the resource id of the connectedRegistry parent), mode, and connectionState.
     * The supported operator is eq.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ConnectedRegistryInner> listAsync(String resourceGroupName, String registryName, String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, registryName, filter),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ConnectedRegistryInner> listAsync(String resourceGroupName, String registryName) {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, registryName, filter),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param filter An OData filter expression that describes a subset of connectedRegistries to return. The parameters
     * that can be filtered are parent.id (the resource id of the connectedRegistry parent), mode, and connectionState.
     * The supported operator is eq.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ConnectedRegistryInner> listAsync(String resourceGroupName, String registryName, String filter,
        Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, registryName, filter, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ConnectedRegistryInner> list(String resourceGroupName, String registryName) {
        final String filter = null;
        return new PagedIterable<>(listAsync(resourceGroupName, registryName, filter));
    }

    /**
     * Lists all connected registries for the specified container registry.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param filter An OData filter expression that describes a subset of connectedRegistries to return. The parameters
     * that can be filtered are parent.id (the resource id of the connectedRegistry parent), mode, and connectionState.
     * The supported operator is eq.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ConnectedRegistryInner> list(String resourceGroupName, String registryName, String filter,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, registryName, filter, context));
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deactivateWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.deactivate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                    resourceGroupName, registryName, connectedRegistryName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deactivateWithResponseAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (connectedRegistryName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter connectedRegistryName is required and cannot be null."));
        }
        final String apiVersion = "2025-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deactivate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, registryName, connectedRegistryName, accept, context);
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeactivateAsync(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deactivateWithResponseAsync(resourceGroupName, registryName, connectedRegistryName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeactivateAsync(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deactivateWithResponseAsync(resourceGroupName, registryName, connectedRegistryName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeactivate(String resourceGroupName, String registryName,
        String connectedRegistryName) {
        return this.beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName).getSyncPoller();
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeactivate(String resourceGroupName, String registryName,
        String connectedRegistryName, Context context) {
        return this.beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName, context)
            .getSyncPoller();
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deactivateAsync(String resourceGroupName, String registryName, String connectedRegistryName) {
        return beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deactivateAsync(String resourceGroupName, String registryName, String connectedRegistryName,
        Context context) {
        return beginDeactivateAsync(resourceGroupName, registryName, connectedRegistryName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deactivate(String resourceGroupName, String registryName, String connectedRegistryName) {
        deactivateAsync(resourceGroupName, registryName, connectedRegistryName).block();
    }

    /**
     * Deactivates the connected registry instance.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param registryName The name of the container registry.
     * @param connectedRegistryName The name of the connected registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deactivate(String resourceGroupName, String registryName, String connectedRegistryName,
        Context context) {
        deactivateAsync(resourceGroupName, registryName, connectedRegistryName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ConnectedRegistryInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list connected registries for a container registry along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectedRegistryInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
