// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The logging properties of the connected registry.
 */
@Fluent
public final class LoggingProperties implements JsonSerializable<LoggingProperties> {
    /*
     * The verbosity of logs persisted on the connected registry.
     */
    private LogLevel logLevel;

    /*
     * Indicates whether audit logs are enabled on the connected registry.
     */
    private AuditLogStatus auditLogStatus;

    /**
     * Creates an instance of LoggingProperties class.
     */
    public LoggingProperties() {
    }

    /**
     * Get the logLevel property: The verbosity of logs persisted on the connected registry.
     * 
     * @return the logLevel value.
     */
    public LogLevel logLevel() {
        return this.logLevel;
    }

    /**
     * Set the logLevel property: The verbosity of logs persisted on the connected registry.
     * 
     * @param logLevel the logLevel value to set.
     * @return the LoggingProperties object itself.
     */
    public LoggingProperties withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    /**
     * Get the auditLogStatus property: Indicates whether audit logs are enabled on the connected registry.
     * 
     * @return the auditLogStatus value.
     */
    public AuditLogStatus auditLogStatus() {
        return this.auditLogStatus;
    }

    /**
     * Set the auditLogStatus property: Indicates whether audit logs are enabled on the connected registry.
     * 
     * @param auditLogStatus the auditLogStatus value to set.
     * @return the LoggingProperties object itself.
     */
    public LoggingProperties withAuditLogStatus(AuditLogStatus auditLogStatus) {
        this.auditLogStatus = auditLogStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logLevel", this.logLevel == null ? null : this.logLevel.toString());
        jsonWriter.writeStringField("auditLogStatus",
            this.auditLogStatus == null ? null : this.auditLogStatus.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoggingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoggingProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoggingProperties.
     */
    public static LoggingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoggingProperties deserializedLoggingProperties = new LoggingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("logLevel".equals(fieldName)) {
                    deserializedLoggingProperties.logLevel = LogLevel.fromString(reader.getString());
                } else if ("auditLogStatus".equals(fieldName)) {
                    deserializedLoggingProperties.auditLogStatus = AuditLogStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoggingProperties;
        });
    }
}
