// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of a timer trigger.
 */
@Fluent
public final class TimerTrigger implements JsonSerializable<TimerTrigger> {
    /*
     * The CRON expression for the task schedule
     */
    private String schedule;

    /*
     * The current status of trigger.
     */
    private TriggerStatus status;

    /*
     * The name of the trigger.
     */
    private String name;

    /**
     * Creates an instance of TimerTrigger class.
     */
    public TimerTrigger() {
    }

    /**
     * Get the schedule property: The CRON expression for the task schedule.
     * 
     * @return the schedule value.
     */
    public String schedule() {
        return this.schedule;
    }

    /**
     * Set the schedule property: The CRON expression for the task schedule.
     * 
     * @param schedule the schedule value to set.
     * @return the TimerTrigger object itself.
     */
    public TimerTrigger withSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    /**
     * Get the status property: The current status of trigger.
     * 
     * @return the status value.
     */
    public TriggerStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of trigger.
     * 
     * @param status the status value to set.
     * @return the TimerTrigger object itself.
     */
    public TimerTrigger withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the name property: The name of the trigger.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the trigger.
     * 
     * @param name the name value to set.
     * @return the TimerTrigger object itself.
     */
    public TimerTrigger withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schedule() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property schedule in model TimerTrigger"));
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model TimerTrigger"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TimerTrigger.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schedule", this.schedule);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimerTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimerTrigger if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TimerTrigger.
     */
    public static TimerTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimerTrigger deserializedTimerTrigger = new TimerTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schedule".equals(fieldName)) {
                    deserializedTimerTrigger.schedule = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTimerTrigger.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedTimerTrigger.status = TriggerStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimerTrigger;
        });
    }
}
