// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The properties of the credentials that can be used for authenticating the token.
 */
@Fluent
public final class TokenCredentialsProperties implements JsonSerializable<TokenCredentialsProperties> {
    /*
     * The certificates property.
     */
    private List<TokenCertificate> certificates;

    /*
     * The passwords property.
     */
    private List<TokenPassword> passwords;

    /**
     * Creates an instance of TokenCredentialsProperties class.
     */
    public TokenCredentialsProperties() {
    }

    /**
     * Get the certificates property: The certificates property.
     * 
     * @return the certificates value.
     */
    public List<TokenCertificate> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: The certificates property.
     * 
     * @param certificates the certificates value to set.
     * @return the TokenCredentialsProperties object itself.
     */
    public TokenCredentialsProperties withCertificates(List<TokenCertificate> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the passwords property: The passwords property.
     * 
     * @return the passwords value.
     */
    public List<TokenPassword> passwords() {
        return this.passwords;
    }

    /**
     * Set the passwords property: The passwords property.
     * 
     * @param passwords the passwords value to set.
     * @return the TokenCredentialsProperties object itself.
     */
    public TokenCredentialsProperties withPasswords(List<TokenPassword> passwords) {
        this.passwords = passwords;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (certificates() != null) {
            certificates().forEach(e -> e.validate());
        }
        if (passwords() != null) {
            passwords().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("passwords", this.passwords, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenCredentialsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenCredentialsProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TokenCredentialsProperties.
     */
    public static TokenCredentialsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenCredentialsProperties deserializedTokenCredentialsProperties = new TokenCredentialsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("certificates".equals(fieldName)) {
                    List<TokenCertificate> certificates
                        = reader.readArray(reader1 -> TokenCertificate.fromJson(reader1));
                    deserializedTokenCredentialsProperties.certificates = certificates;
                } else if ("passwords".equals(fieldName)) {
                    List<TokenPassword> passwords = reader.readArray(reader1 -> TokenPassword.fromJson(reader1));
                    deserializedTokenCredentialsProperties.passwords = passwords;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenCredentialsProperties;
        });
    }
}
