/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import java.io.IOException;
import java.util.List;

public final class WebhookProperties
implements JsonSerializable<WebhookProperties> {
    private WebhookStatus status;
    private String scope;
    private List<WebhookAction> actions;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(WebhookProperties.class);

    public WebhookStatus status() {
        return this.status;
    }

    public WebhookProperties withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public WebhookProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<WebhookAction> actions() {
        return this.actions;
    }

    public WebhookProperties withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.actions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actions in model WebhookProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("scope", this.scope);
        return jsonWriter.writeEndObject();
    }

    public static WebhookProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookProperties)jsonReader.readObject(reader -> {
            WebhookProperties deserializedWebhookProperties = new WebhookProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedWebhookProperties.actions = actions = reader.readArray(reader1 -> WebhookAction.fromString(reader1.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWebhookProperties.status = WebhookStatus.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedWebhookProperties.scope = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedWebhookProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookProperties;
        });
    }
}

