/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.EncryptionStatus;
import com.azure.resourcemanager.containerregistry.models.KeyVaultProperties;
import java.io.IOException;

public final class EncryptionProperty
implements JsonSerializable<EncryptionProperty> {
    private EncryptionStatus status;
    private KeyVaultProperties keyVaultProperties;

    public EncryptionStatus status() {
        return this.status;
    }

    public EncryptionProperty withStatus(EncryptionStatus status) {
        this.status = status;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionProperty withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionProperty fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionProperty)jsonReader.readObject(reader -> {
            EncryptionProperty deserializedEncryptionProperty = new EncryptionProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedEncryptionProperty.status = EncryptionStatus.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionProperty.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionProperty;
        });
    }
}

