/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.Architecture;
import com.azure.resourcemanager.containerregistry.models.OS;
import com.azure.resourcemanager.containerregistry.models.Variant;
import java.io.IOException;

public final class PlatformUpdateParameters
implements JsonSerializable<PlatformUpdateParameters> {
    private OS os;
    private Architecture architecture;
    private Variant variant;

    public OS os() {
        return this.os;
    }

    public PlatformUpdateParameters withOs(OS os) {
        this.os = os;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public PlatformUpdateParameters withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public Variant variant() {
        return this.variant;
    }

    public PlatformUpdateParameters withVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("os", this.os == null ? null : this.os.toString());
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeStringField("variant", this.variant == null ? null : this.variant.toString());
        return jsonWriter.writeEndObject();
    }

    public static PlatformUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PlatformUpdateParameters)jsonReader.readObject(reader -> {
            PlatformUpdateParameters deserializedPlatformUpdateParameters = new PlatformUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("os".equals(fieldName)) {
                    deserializedPlatformUpdateParameters.os = OS.fromString(reader.getString());
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedPlatformUpdateParameters.architecture = Architecture.fromString(reader.getString());
                    continue;
                }
                if ("variant".equals(fieldName)) {
                    deserializedPlatformUpdateParameters.variant = Variant.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlatformUpdateParameters;
        });
    }
}

