/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.DockerBuildStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.EncodedTaskStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.FileTaskStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.StepType;
import java.io.IOException;

public class TaskStepUpdateParameters
implements JsonSerializable<TaskStepUpdateParameters> {
    private StepType type = StepType.fromString("TaskStepUpdateParameters");
    private String contextPath;
    private String contextAccessToken;

    public StepType type() {
        return this.type;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public TaskStepUpdateParameters withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String contextAccessToken() {
        return this.contextAccessToken;
    }

    public TaskStepUpdateParameters withContextAccessToken(String contextAccessToken) {
        this.contextAccessToken = contextAccessToken;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("contextPath", this.contextPath);
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken);
        return jsonWriter.writeEndObject();
    }

    public static TaskStepUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TaskStepUpdateParameters)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Object fieldName;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Docker".equals(discriminatorValue)) {
                    fieldName = DockerBuildStepUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("FileTask".equals(discriminatorValue)) {
                    fieldName = FileTaskStepUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("EncodedTask".equals(discriminatorValue)) {
                    fieldName = EncodedTaskStepUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                fieldName = TaskStepUpdateParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                return fieldName;
            }
        });
    }

    static TaskStepUpdateParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (TaskStepUpdateParameters)jsonReader.readObject(reader -> {
            TaskStepUpdateParameters deserializedTaskStepUpdateParameters = new TaskStepUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTaskStepUpdateParameters.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedTaskStepUpdateParameters.contextPath = reader.getString();
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedTaskStepUpdateParameters.contextAccessToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskStepUpdateParameters;
        });
    }
}

