/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class RegistryUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RegistryUpdateParameters.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties.adminUserEnabled")
    private Boolean adminUserEnabled;
    @JsonProperty(value="properties.networkRuleSet")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="properties.policies")
    private Policies policies;

    public Map<String, String> tags() {
        return this.tags;
    }

    public RegistryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public RegistryUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    public RegistryUpdateParameters withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public RegistryUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public Policies policies() {
        return this.policies;
    }

    public RegistryUpdateParameters withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.policies() != null) {
            this.policies().validate();
        }
    }
}

