// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerregistry.fluent.models.RunGetLogResultInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RunsClient. */
public interface RunsClient {
    /**
     * Gets all the runs for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The runs filter to apply on the operation. Arithmetic operators are not supported. The allowed
     *     string function is 'contains'. All logical operators except 'Not', 'Has', 'All' are allowed.
     * @param top $top is supported for get list of runs, which limits the maximum number of runs to return.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the runs for a registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RunInner> listAsync(String resourceGroupName, String registryName, String filter, Integer top);

    /**
     * Gets all the runs for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the runs for a registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RunInner> listAsync(String resourceGroupName, String registryName);

    /**
     * Gets all the runs for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param filter The runs filter to apply on the operation. Arithmetic operators are not supported. The allowed
     *     string function is 'contains'. All logical operators except 'Not', 'Has', 'All' are allowed.
     * @param top $top is supported for get list of runs, which limits the maximum number of runs to return.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the runs for a registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RunInner> list(
        String resourceGroupName, String registryName, String filter, Integer top, Context context);

    /**
     * Gets all the runs for a registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the runs for a registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RunInner> list(String resourceGroupName, String registryName);

    /**
     * Gets the detailed information for a given run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detailed information for a given run.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RunInner>> getWithResponseAsync(String resourceGroupName, String registryName, String runId);

    /**
     * Gets the detailed information for a given run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detailed information for a given run.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RunInner> getAsync(String resourceGroupName, String registryName, String runId);

    /**
     * Gets the detailed information for a given run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detailed information for a given run.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunInner get(String resourceGroupName, String registryName, String runId);

    /**
     * Gets the detailed information for a given run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detailed information for a given run.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RunInner> getWithResponse(String resourceGroupName, String registryName, String runId, Context context);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<RunInner>, RunInner> beginUpdateAsync(
        String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<RunInner>, RunInner> beginUpdate(
        String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<RunInner>, RunInner> beginUpdate(
        String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled, Context context);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RunInner> updateAsync(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RunInner> updateAsync(String resourceGroupName, String registryName, String runId);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunInner update(String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param isArchiveEnabled The value that indicates whether archiving is enabled or not.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunInner update(
        String resourceGroupName, String registryName, String runId, Boolean isArchiveEnabled, Context context);

    /**
     * Patch the run properties.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return run resource properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunInner update(String resourceGroupName, String registryName, String runId);

    /**
     * Gets a link to download the run logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a link to download the run logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RunGetLogResultInner>> getLogSasUrlWithResponseAsync(
        String resourceGroupName, String registryName, String runId);

    /**
     * Gets a link to download the run logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a link to download the run logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RunGetLogResultInner> getLogSasUrlAsync(String resourceGroupName, String registryName, String runId);

    /**
     * Gets a link to download the run logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a link to download the run logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RunGetLogResultInner getLogSasUrl(String resourceGroupName, String registryName, String runId);

    /**
     * Gets a link to download the run logs.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a link to download the run logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RunGetLogResultInner> getLogSasUrlWithResponse(
        String resourceGroupName, String registryName, String runId, Context context);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> cancelWithResponseAsync(
        String resourceGroupName, String registryName, String runId);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginCancelAsync(String resourceGroupName, String registryName, String runId);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginCancel(String resourceGroupName, String registryName, String runId);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginCancel(
        String resourceGroupName, String registryName, String runId, Context context);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> cancelAsync(String resourceGroupName, String registryName, String runId);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancel(String resourceGroupName, String registryName, String runId);

    /**
     * Cancel an existing run.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param runId The run ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void cancel(String resourceGroupName, String registryName, String runId, Context context);
}
