// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** The parameters for a task run request. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("TaskRunRequest")
@Fluent
public final class TaskRunRequest extends RunRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TaskRunRequest.class);

    /*
     * The name of task against which run has to be queued.
     */
    @JsonProperty(value = "taskName", required = true)
    private String taskName;

    /*
     * The collection of overridable values that can be passed when running a
     * task.
     */
    @JsonProperty(value = "values")
    private List<SetValue> values;

    /**
     * Get the taskName property: The name of task against which run has to be queued.
     *
     * @return the taskName value.
     */
    public String taskName() {
        return this.taskName;
    }

    /**
     * Set the taskName property: The name of task against which run has to be queued.
     *
     * @param taskName the taskName value to set.
     * @return the TaskRunRequest object itself.
     */
    public TaskRunRequest withTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * Get the values property: The collection of overridable values that can be passed when running a task.
     *
     * @return the values value.
     */
    public List<SetValue> values() {
        return this.values;
    }

    /**
     * Set the values property: The collection of overridable values that can be passed when running a task.
     *
     * @param values the values value to set.
     * @return the TaskRunRequest object itself.
     */
    public TaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (taskName() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property taskName in model TaskRunRequest"));
        }
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }
}
