/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAadProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAddonProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterApiServerAccessProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterIdentity;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPropertiesAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSku;
import com.azure.resourcemanager.containerservice.models.ManagedClusterWindowsProfile;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class ManagedClusterInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ManagedClusterInner.class);
    @JsonProperty(value="sku")
    private ManagedClusterSku sku;
    @JsonProperty(value="identity")
    private ManagedClusterIdentity identity;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.maxAgentPools", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maxAgentPools;
    @JsonProperty(value="properties.kubernetesVersion")
    private String kubernetesVersion;
    @JsonProperty(value="properties.dnsPrefix")
    private String dnsPrefix;
    @JsonProperty(value="properties.fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;
    @JsonProperty(value="properties.privateFQDN", access=JsonProperty.Access.WRITE_ONLY)
    private String privateFqdn;
    @JsonProperty(value="properties.agentPoolProfiles")
    private List<ManagedClusterAgentPoolProfile> agentPoolProfiles;
    @JsonProperty(value="properties.linuxProfile")
    private ContainerServiceLinuxProfile linuxProfile;
    @JsonProperty(value="properties.windowsProfile")
    private ManagedClusterWindowsProfile windowsProfile;
    @JsonProperty(value="properties.servicePrincipalProfile")
    private ManagedClusterServicePrincipalProfile servicePrincipalProfile;
    @JsonProperty(value="properties.addonProfiles")
    private Map<String, ManagedClusterAddonProfile> addonProfiles;
    @JsonProperty(value="properties.nodeResourceGroup")
    private String nodeResourceGroup;
    @JsonProperty(value="properties.enableRBAC")
    private Boolean enableRbac;
    @JsonProperty(value="properties.enablePodSecurityPolicy")
    private Boolean enablePodSecurityPolicy;
    @JsonProperty(value="properties.networkProfile")
    private ContainerServiceNetworkProfile networkProfile;
    @JsonProperty(value="properties.aadProfile")
    private ManagedClusterAadProfile aadProfile;
    @JsonProperty(value="properties.autoScalerProfile")
    private ManagedClusterPropertiesAutoScalerProfile autoScalerProfile;
    @JsonProperty(value="properties.apiServerAccessProfile")
    private ManagedClusterApiServerAccessProfile apiServerAccessProfile;
    @JsonProperty(value="properties.diskEncryptionSetID")
    private String diskEncryptionSetId;
    @JsonProperty(value="properties.identityProfile")
    private Map<String, UserAssignedIdentity> identityProfile;

    public ManagedClusterSku sku() {
        return this.sku;
    }

    public ManagedClusterInner withSku(ManagedClusterSku sku) {
        this.sku = sku;
        return this;
    }

    public ManagedClusterIdentity identity() {
        return this.identity;
    }

    public ManagedClusterInner withIdentity(ManagedClusterIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Integer maxAgentPools() {
        return this.maxAgentPools;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public ManagedClusterInner withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    public ManagedClusterInner withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String privateFqdn() {
        return this.privateFqdn;
    }

    public List<ManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public ManagedClusterInner withAgentPoolProfiles(List<ManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    public ManagedClusterInner withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    public ManagedClusterWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    public ManagedClusterInner withWindowsProfile(ManagedClusterWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    public ManagedClusterServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    public ManagedClusterInner withServicePrincipalProfile(ManagedClusterServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return this.addonProfiles;
    }

    public ManagedClusterInner withAddonProfiles(Map<String, ManagedClusterAddonProfile> addonProfiles) {
        this.addonProfiles = addonProfiles;
        return this;
    }

    public String nodeResourceGroup() {
        return this.nodeResourceGroup;
    }

    public ManagedClusterInner withNodeResourceGroup(String nodeResourceGroup) {
        this.nodeResourceGroup = nodeResourceGroup;
        return this;
    }

    public Boolean enableRbac() {
        return this.enableRbac;
    }

    public ManagedClusterInner withEnableRbac(Boolean enableRbac) {
        this.enableRbac = enableRbac;
        return this;
    }

    public Boolean enablePodSecurityPolicy() {
        return this.enablePodSecurityPolicy;
    }

    public ManagedClusterInner withEnablePodSecurityPolicy(Boolean enablePodSecurityPolicy) {
        this.enablePodSecurityPolicy = enablePodSecurityPolicy;
        return this;
    }

    public ContainerServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public ManagedClusterInner withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public ManagedClusterAadProfile aadProfile() {
        return this.aadProfile;
    }

    public ManagedClusterInner withAadProfile(ManagedClusterAadProfile aadProfile) {
        this.aadProfile = aadProfile;
        return this;
    }

    public ManagedClusterPropertiesAutoScalerProfile autoScalerProfile() {
        return this.autoScalerProfile;
    }

    public ManagedClusterInner withAutoScalerProfile(ManagedClusterPropertiesAutoScalerProfile autoScalerProfile) {
        this.autoScalerProfile = autoScalerProfile;
        return this;
    }

    public ManagedClusterApiServerAccessProfile apiServerAccessProfile() {
        return this.apiServerAccessProfile;
    }

    public ManagedClusterInner withApiServerAccessProfile(ManagedClusterApiServerAccessProfile apiServerAccessProfile) {
        this.apiServerAccessProfile = apiServerAccessProfile;
        return this;
    }

    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    public ManagedClusterInner withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    public Map<String, UserAssignedIdentity> identityProfile() {
        return this.identityProfile;
    }

    public ManagedClusterInner withIdentityProfile(Map<String, UserAssignedIdentity> identityProfile) {
        this.identityProfile = identityProfile;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.agentPoolProfiles() != null) {
            this.agentPoolProfiles().forEach(e -> e.validate());
        }
        if (this.linuxProfile() != null) {
            this.linuxProfile().validate();
        }
        if (this.windowsProfile() != null) {
            this.windowsProfile().validate();
        }
        if (this.servicePrincipalProfile() != null) {
            this.servicePrincipalProfile().validate();
        }
        if (this.addonProfiles() != null) {
            this.addonProfiles().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.aadProfile() != null) {
            this.aadProfile().validate();
        }
        if (this.autoScalerProfile() != null) {
            this.autoScalerProfile().validate();
        }
        if (this.apiServerAccessProfile() != null) {
            this.apiServerAccessProfile().validate();
        }
        if (this.identityProfile() != null) {
            this.identityProfile().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

