/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.containerservice.ContainerServiceManager;
import com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.azure.resourcemanager.containerservice.fluent.ManagedClustersClient;
import com.azure.resourcemanager.containerservice.fluent.models.CredentialResultsInner;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterInner;
import com.azure.resourcemanager.containerservice.fluent.models.OrchestratorVersionProfileListResultInner;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterImpl;
import com.azure.resourcemanager.containerservice.models.CredentialResult;
import com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.azure.resourcemanager.containerservice.models.KubernetesClusters;
import com.azure.resourcemanager.containerservice.models.OrchestratorVersionProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import reactor.core.publisher.Mono;

public class KubernetesClustersImpl
extends GroupableResourcesImpl<KubernetesCluster, KubernetesClusterImpl, ManagedClusterInner, ManagedClustersClient, ContainerServiceManager>
implements KubernetesClusters {
    public KubernetesClustersImpl(ContainerServiceManager containerServiceManager) {
        super((Object)((ContainerServiceManagementClient)containerServiceManager.serviceClient()).getManagedClusters(), (Manager)containerServiceManager);
    }

    public PagedIterable<KubernetesCluster> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<KubernetesCluster> listAsync() {
        return ((ManagedClustersClient)this.inner()).listAsync().mapPage(inner -> new KubernetesClusterImpl(inner.name(), (ManagedClusterInner)((Object)inner), (ContainerServiceManager)this.manager()));
    }

    public PagedIterable<KubernetesCluster> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(((ManagedClustersClient)this.inner()).listByResourceGroup(resourceGroupName));
    }

    public PagedFlux<KubernetesCluster> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((ManagedClustersClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected Mono<ManagedClusterInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ManagedClustersClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ManagedClustersClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    protected KubernetesClusterImpl wrapModel(String name) {
        return new KubernetesClusterImpl(name, new ManagedClusterInner(), (ContainerServiceManager)this.manager());
    }

    protected KubernetesClusterImpl wrapModel(ManagedClusterInner inner) {
        if (inner == null) {
            return null;
        }
        return new KubernetesClusterImpl(inner.name(), inner, (ContainerServiceManager)this.manager());
    }

    public KubernetesClusterImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Set<String> listKubernetesVersions(Region region) {
        TreeSet<String> kubernetesVersions = new TreeSet<String>();
        OrchestratorVersionProfileListResultInner inner = ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getContainerServices().listOrchestrators(region.name());
        if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
            for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                kubernetesVersions.add(orchestrator.orchestratorVersion());
            }
        }
        return Collections.unmodifiableSet(kubernetesVersions);
    }

    @Override
    public Mono<Set<String>> listKubernetesVersionsAsync(Region region) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getContainerServices().listOrchestratorsAsync(region.name()).map(inner -> {
            TreeSet<String> kubernetesVersions = new TreeSet<String>();
            if (inner != null && inner.orchestrators() != null && inner.orchestrators().size() > 0) {
                for (OrchestratorVersionProfile orchestrator : inner.orchestrators()) {
                    if (!orchestrator.orchestratorType().equals("Kubernetes")) continue;
                    kubernetesVersions.add(orchestrator.orchestratorVersion());
                }
            }
            return Collections.unmodifiableSet(kubernetesVersions);
        });
    }

    @Override
    public List<CredentialResult> listAdminKubeConfigContent(String resourceGroupName, String kubernetesClusterName) {
        return (List)this.listAdminKubeConfigContentAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    public Mono<List<CredentialResult>> listAdminKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().listClusterAdminCredentialsAsync(resourceGroupName, kubernetesClusterName).map(CredentialResultsInner::kubeconfigs);
    }

    @Override
    public List<CredentialResult> listUserKubeConfigContent(String resourceGroupName, String kubernetesClusterName) {
        return (List)this.listUserKubeConfigContentAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    public Mono<List<CredentialResult>> listUserKubeConfigContentAsync(String resourceGroupName, String kubernetesClusterName) {
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().listClusterUserCredentialsAsync(resourceGroupName, kubernetesClusterName).map(CredentialResultsInner::kubeconfigs);
    }
}

