/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.NetworkProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAuthProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterMasterPoolProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftRouterProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class OpenShiftManagedClusterProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OpenShiftManagedClusterProperties.class);
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="openShiftVersion", required=true)
    private String openShiftVersion;
    @JsonProperty(value="clusterVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String clusterVersion;
    @JsonProperty(value="publicHostname", access=JsonProperty.Access.WRITE_ONLY)
    private String publicHostname;
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;
    @JsonProperty(value="networkProfile")
    private NetworkProfile networkProfile;
    @JsonProperty(value="routerProfiles")
    private List<OpenShiftRouterProfile> routerProfiles;
    @JsonProperty(value="masterPoolProfile")
    private OpenShiftManagedClusterMasterPoolProfile masterPoolProfile;
    @JsonProperty(value="agentPoolProfiles")
    private List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles;
    @JsonProperty(value="authProfile")
    private OpenShiftManagedClusterAuthProfile authProfile;

    public String provisioningState() {
        return this.provisioningState;
    }

    public String openShiftVersion() {
        return this.openShiftVersion;
    }

    public OpenShiftManagedClusterProperties withOpenShiftVersion(String openShiftVersion) {
        this.openShiftVersion = openShiftVersion;
        return this;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String publicHostname() {
        return this.publicHostname;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public OpenShiftManagedClusterProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public List<OpenShiftRouterProfile> routerProfiles() {
        return this.routerProfiles;
    }

    public OpenShiftManagedClusterProperties withRouterProfiles(List<OpenShiftRouterProfile> routerProfiles) {
        this.routerProfiles = routerProfiles;
        return this;
    }

    public OpenShiftManagedClusterMasterPoolProfile masterPoolProfile() {
        return this.masterPoolProfile;
    }

    public OpenShiftManagedClusterProperties withMasterPoolProfile(OpenShiftManagedClusterMasterPoolProfile masterPoolProfile) {
        this.masterPoolProfile = masterPoolProfile;
        return this;
    }

    public List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public OpenShiftManagedClusterProperties withAgentPoolProfiles(List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public OpenShiftManagedClusterAuthProfile authProfile() {
        return this.authProfile;
    }

    public OpenShiftManagedClusterProperties withAuthProfile(OpenShiftManagedClusterAuthProfile authProfile) {
        this.authProfile = authProfile;
        return this;
    }

    public void validate() {
        if (this.openShiftVersion() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property openShiftVersion in model OpenShiftManagedClusterProperties"));
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.routerProfiles() != null) {
            this.routerProfiles().forEach(e -> e.validate());
        }
        if (this.masterPoolProfile() != null) {
            this.masterPoolProfile().validate();
        }
        if (this.agentPoolProfiles() != null) {
            this.agentPoolProfiles().forEach(e -> e.validate());
        }
        if (this.authProfile() != null) {
            this.authProfile().validate();
        }
    }
}

