// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerservice.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAadProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAddonProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterApiServerAccessProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAutoUpgradeProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterHttpProxyConfig;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentityProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPropertiesAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSecurityProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterStorageProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterWindowsProfile;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Properties of the managed cluster. */
@Fluent
public final class ManagedClusterProperties {
    /*
     * The current provisioning state.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * The Power State of the cluster.
     */
    @JsonProperty(value = "powerState", access = JsonProperty.Access.WRITE_ONLY)
    private PowerState powerState;

    /*
     * The max number of agent pools for the managed cluster.
     */
    @JsonProperty(value = "maxAgentPools", access = JsonProperty.Access.WRITE_ONLY)
    private Integer maxAgentPools;

    /*
     * The version of Kubernetes specified by the user. Both patch version
     * <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are
     * supported. When <major.minor> is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the
     * same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will
     * not trigger an upgrade, even if a newer patch version is available. When
     * you upgrade a supported AKS cluster, Kubernetes minor versions cannot be
     * skipped. All upgrades must be performed sequentially by major version
     * number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x ->
     * 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See
     * [upgrading an AKS
     * cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more
     * details.
     */
    @JsonProperty(value = "kubernetesVersion")
    private String kubernetesVersion;

    /*
     * The version of Kubernetes the Managed Cluster is running. If
     * kubernetesVersion was a fully specified version <major.minor.patch>,
     * this field will be exactly equal to it. If kubernetesVersion was
     * <major.minor>, this field will contain the full <major.minor.patch>
     * version being used.
     */
    @JsonProperty(value = "currentKubernetesVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String currentKubernetesVersion;

    /*
     * The DNS prefix of the Managed Cluster. This cannot be updated once the
     * Managed Cluster has been created.
     */
    @JsonProperty(value = "dnsPrefix")
    private String dnsPrefix;

    /*
     * The FQDN subdomain of the private cluster with custom private dns zone.
     * This cannot be updated once the Managed Cluster has been created.
     */
    @JsonProperty(value = "fqdnSubdomain")
    private String fqdnSubdomain;

    /*
     * The FQDN of the master pool.
     */
    @JsonProperty(value = "fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /*
     * The FQDN of private cluster.
     */
    @JsonProperty(value = "privateFQDN", access = JsonProperty.Access.WRITE_ONLY)
    private String privateFqdn;

    /*
     * The special FQDN used by the Azure Portal to access the Managed Cluster.
     * This FQDN is for use only by the Azure Portal and should not be used by
     * other clients. The Azure Portal requires certain Cross-Origin Resource
     * Sharing (CORS) headers to be sent in some responses, which Kubernetes
     * APIServer doesn't handle by default. This special FQDN supports CORS,
     * allowing the Azure Portal to function properly.
     */
    @JsonProperty(value = "azurePortalFQDN", access = JsonProperty.Access.WRITE_ONLY)
    private String azurePortalFqdn;

    /*
     * The agent pool properties.
     */
    @JsonProperty(value = "agentPoolProfiles")
    private List<ManagedClusterAgentPoolProfile> agentPoolProfiles;

    /*
     * The profile for Linux VMs in the Managed Cluster.
     */
    @JsonProperty(value = "linuxProfile")
    private ContainerServiceLinuxProfile linuxProfile;

    /*
     * The profile for Windows VMs in the Managed Cluster.
     */
    @JsonProperty(value = "windowsProfile")
    private ManagedClusterWindowsProfile windowsProfile;

    /*
     * Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     */
    @JsonProperty(value = "servicePrincipalProfile")
    private ManagedClusterServicePrincipalProfile servicePrincipalProfile;

    /*
     * The profile of managed cluster add-on.
     */
    @JsonProperty(value = "addonProfiles")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, ManagedClusterAddonProfile> addonProfiles;

    /*
     * The pod identity profile of the Managed Cluster. See [use AAD pod
     * identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity)
     * for more details on AAD pod identity integration.
     */
    @JsonProperty(value = "podIdentityProfile")
    private ManagedClusterPodIdentityProfile podIdentityProfile;

    /*
     * The name of the resource group containing agent pool nodes.
     */
    @JsonProperty(value = "nodeResourceGroup")
    private String nodeResourceGroup;

    /*
     * Whether to enable Kubernetes Role-Based Access Control.
     */
    @JsonProperty(value = "enableRBAC")
    private Boolean enableRbac;

    /*
     * (DEPRECATING) Whether to enable Kubernetes pod security policy
     * (preview). This feature is set for removal on October 15th, 2020. Learn
     * more at aka.ms/aks/azpodpolicy.
     */
    @JsonProperty(value = "enablePodSecurityPolicy")
    private Boolean enablePodSecurityPolicy;

    /*
     * The network configuration profile.
     */
    @JsonProperty(value = "networkProfile")
    private ContainerServiceNetworkProfile networkProfile;

    /*
     * AADProfile specifies attributes for Azure Active Directory integration.
     * The Azure Active Directory configuration.
     */
    @JsonProperty(value = "aadProfile")
    private ManagedClusterAadProfile aadProfile;

    /*
     * The auto upgrade configuration.
     */
    @JsonProperty(value = "autoUpgradeProfile")
    private ManagedClusterAutoUpgradeProfile autoUpgradeProfile;

    /*
     * Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JsonProperty(value = "autoScalerProfile")
    private ManagedClusterPropertiesAutoScalerProfile autoScalerProfile;

    /*
     * The access profile for managed cluster API server.
     */
    @JsonProperty(value = "apiServerAccessProfile")
    private ManagedClusterApiServerAccessProfile apiServerAccessProfile;

    /*
     * The Resource ID of the disk encryption set to use for enabling
     * encryption at rest. This is of the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
     */
    @JsonProperty(value = "diskEncryptionSetID")
    private String diskEncryptionSetId;

    /*
     * Identities associated with the cluster.
     */
    @JsonProperty(value = "identityProfile")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, UserAssignedIdentity> identityProfile;

    /*
     * Private link resources associated with the cluster.
     */
    @JsonProperty(value = "privateLinkResources")
    private List<PrivateLinkResourceInner> privateLinkResources;

    /*
     * If local accounts should be disabled on the Managed Cluster. If set to
     * true, getting static credentials will be disabled for this cluster. This
     * must only be used on Managed Clusters that are AAD enabled. For more
     * details see [disable local
     * accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    @JsonProperty(value = "disableLocalAccounts")
    private Boolean disableLocalAccounts;

    /*
     * Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JsonProperty(value = "httpProxyConfig")
    private ManagedClusterHttpProxyConfig httpProxyConfig;

    /*
     * Security profile for the managed cluster.
     */
    @JsonProperty(value = "securityProfile")
    private ManagedClusterSecurityProfile securityProfile;

    /*
     * Storage profile for the managed cluster.
     */
    @JsonProperty(value = "storageProfile")
    private ManagedClusterStorageProfile storageProfile;

    /*
     * PublicNetworkAccess of the managedCluster Allow or deny public network
     * access for AKS
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    /**
     * Get the provisioningState property: The current provisioning state.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the powerState property: The Power State of the cluster.
     *
     * @return the powerState value.
     */
    public PowerState powerState() {
        return this.powerState;
    }

    /**
     * Get the maxAgentPools property: The max number of agent pools for the managed cluster.
     *
     * @return the maxAgentPools value.
     */
    public Integer maxAgentPools() {
        return this.maxAgentPools;
    }

    /**
     * Get the kubernetesVersion property: The version of Kubernetes specified by the user. Both patch version
     * &lt;major.minor.patch&gt; (e.g. 1.20.13) and &lt;major.minor&gt; (e.g. 1.20) are supported. When
     * &lt;major.minor&gt; is specified, the latest supported GA patch version is chosen automatically. Updating the
     * cluster with the same &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14) will not trigger an
     * upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor
     * versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example,
     * upgrades between 1.14.x -&gt; 1.15.x or 1.15.x -&gt; 1.16.x are allowed, however 1.14.x -&gt; 1.16.x is not
     * allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     *
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: The version of Kubernetes specified by the user. Both patch version
     * &lt;major.minor.patch&gt; (e.g. 1.20.13) and &lt;major.minor&gt; (e.g. 1.20) are supported. When
     * &lt;major.minor&gt; is specified, the latest supported GA patch version is chosen automatically. Updating the
     * cluster with the same &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14) will not trigger an
     * upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor
     * versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example,
     * upgrades between 1.14.x -&gt; 1.15.x or 1.15.x -&gt; 1.16.x are allowed, however 1.14.x -&gt; 1.16.x is not
     * allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     *
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the currentKubernetesVersion property: The version of Kubernetes the Managed Cluster is running. If
     * kubernetesVersion was a fully specified version &lt;major.minor.patch&gt;, this field will be exactly equal to
     * it. If kubernetesVersion was &lt;major.minor&gt;, this field will contain the full &lt;major.minor.patch&gt;
     * version being used.
     *
     * @return the currentKubernetesVersion value.
     */
    public String currentKubernetesVersion() {
        return this.currentKubernetesVersion;
    }

    /**
     * Get the dnsPrefix property: The DNS prefix of the Managed Cluster. This cannot be updated once the Managed
     * Cluster has been created.
     *
     * @return the dnsPrefix value.
     */
    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    /**
     * Set the dnsPrefix property: The DNS prefix of the Managed Cluster. This cannot be updated once the Managed
     * Cluster has been created.
     *
     * @param dnsPrefix the dnsPrefix value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    /**
     * Get the fqdnSubdomain property: The FQDN subdomain of the private cluster with custom private dns zone. This
     * cannot be updated once the Managed Cluster has been created.
     *
     * @return the fqdnSubdomain value.
     */
    public String fqdnSubdomain() {
        return this.fqdnSubdomain;
    }

    /**
     * Set the fqdnSubdomain property: The FQDN subdomain of the private cluster with custom private dns zone. This
     * cannot be updated once the Managed Cluster has been created.
     *
     * @param fqdnSubdomain the fqdnSubdomain value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withFqdnSubdomain(String fqdnSubdomain) {
        this.fqdnSubdomain = fqdnSubdomain;
        return this;
    }

    /**
     * Get the fqdn property: The FQDN of the master pool.
     *
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the privateFqdn property: The FQDN of private cluster.
     *
     * @return the privateFqdn value.
     */
    public String privateFqdn() {
        return this.privateFqdn;
    }

    /**
     * Get the azurePortalFqdn property: The special FQDN used by the Azure Portal to access the Managed Cluster. This
     * FQDN is for use only by the Azure Portal and should not be used by other clients. The Azure Portal requires
     * certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer
     * doesn't handle by default. This special FQDN supports CORS, allowing the Azure Portal to function properly.
     *
     * @return the azurePortalFqdn value.
     */
    public String azurePortalFqdn() {
        return this.azurePortalFqdn;
    }

    /**
     * Get the agentPoolProfiles property: The agent pool properties.
     *
     * @return the agentPoolProfiles value.
     */
    public List<ManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles property: The agent pool properties.
     *
     * @param agentPoolProfiles the agentPoolProfiles value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAgentPoolProfiles(List<ManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Get the linuxProfile property: The profile for Linux VMs in the Managed Cluster.
     *
     * @return the linuxProfile value.
     */
    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    /**
     * Set the linuxProfile property: The profile for Linux VMs in the Managed Cluster.
     *
     * @param linuxProfile the linuxProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    /**
     * Get the windowsProfile property: The profile for Windows VMs in the Managed Cluster.
     *
     * @return the windowsProfile value.
     */
    public ManagedClusterWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    /**
     * Set the windowsProfile property: The profile for Windows VMs in the Managed Cluster.
     *
     * @param windowsProfile the windowsProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withWindowsProfile(ManagedClusterWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    /**
     * Get the servicePrincipalProfile property: Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     *
     * @return the servicePrincipalProfile value.
     */
    public ManagedClusterServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    /**
     * Set the servicePrincipalProfile property: Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     *
     * @param servicePrincipalProfile the servicePrincipalProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withServicePrincipalProfile(
        ManagedClusterServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    /**
     * Get the addonProfiles property: The profile of managed cluster add-on.
     *
     * @return the addonProfiles value.
     */
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return this.addonProfiles;
    }

    /**
     * Set the addonProfiles property: The profile of managed cluster add-on.
     *
     * @param addonProfiles the addonProfiles value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAddonProfiles(Map<String, ManagedClusterAddonProfile> addonProfiles) {
        this.addonProfiles = addonProfiles;
        return this;
    }

    /**
     * Get the podIdentityProfile property: The pod identity profile of the Managed Cluster. See [use AAD pod
     * identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity
     * integration.
     *
     * @return the podIdentityProfile value.
     */
    public ManagedClusterPodIdentityProfile podIdentityProfile() {
        return this.podIdentityProfile;
    }

    /**
     * Set the podIdentityProfile property: The pod identity profile of the Managed Cluster. See [use AAD pod
     * identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity
     * integration.
     *
     * @param podIdentityProfile the podIdentityProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withPodIdentityProfile(ManagedClusterPodIdentityProfile podIdentityProfile) {
        this.podIdentityProfile = podIdentityProfile;
        return this;
    }

    /**
     * Get the nodeResourceGroup property: The name of the resource group containing agent pool nodes.
     *
     * @return the nodeResourceGroup value.
     */
    public String nodeResourceGroup() {
        return this.nodeResourceGroup;
    }

    /**
     * Set the nodeResourceGroup property: The name of the resource group containing agent pool nodes.
     *
     * @param nodeResourceGroup the nodeResourceGroup value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withNodeResourceGroup(String nodeResourceGroup) {
        this.nodeResourceGroup = nodeResourceGroup;
        return this;
    }

    /**
     * Get the enableRbac property: Whether to enable Kubernetes Role-Based Access Control.
     *
     * @return the enableRbac value.
     */
    public Boolean enableRbac() {
        return this.enableRbac;
    }

    /**
     * Set the enableRbac property: Whether to enable Kubernetes Role-Based Access Control.
     *
     * @param enableRbac the enableRbac value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withEnableRbac(Boolean enableRbac) {
        this.enableRbac = enableRbac;
        return this;
    }

    /**
     * Get the enablePodSecurityPolicy property: (DEPRECATING) Whether to enable Kubernetes pod security policy
     * (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
     *
     * @return the enablePodSecurityPolicy value.
     */
    public Boolean enablePodSecurityPolicy() {
        return this.enablePodSecurityPolicy;
    }

    /**
     * Set the enablePodSecurityPolicy property: (DEPRECATING) Whether to enable Kubernetes pod security policy
     * (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
     *
     * @param enablePodSecurityPolicy the enablePodSecurityPolicy value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withEnablePodSecurityPolicy(Boolean enablePodSecurityPolicy) {
        this.enablePodSecurityPolicy = enablePodSecurityPolicy;
        return this;
    }

    /**
     * Get the networkProfile property: The network configuration profile.
     *
     * @return the networkProfile value.
     */
    public ContainerServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: The network configuration profile.
     *
     * @param networkProfile the networkProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the aadProfile property: AADProfile specifies attributes for Azure Active Directory integration. The Azure
     * Active Directory configuration.
     *
     * @return the aadProfile value.
     */
    public ManagedClusterAadProfile aadProfile() {
        return this.aadProfile;
    }

    /**
     * Set the aadProfile property: AADProfile specifies attributes for Azure Active Directory integration. The Azure
     * Active Directory configuration.
     *
     * @param aadProfile the aadProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAadProfile(ManagedClusterAadProfile aadProfile) {
        this.aadProfile = aadProfile;
        return this;
    }

    /**
     * Get the autoUpgradeProfile property: The auto upgrade configuration.
     *
     * @return the autoUpgradeProfile value.
     */
    public ManagedClusterAutoUpgradeProfile autoUpgradeProfile() {
        return this.autoUpgradeProfile;
    }

    /**
     * Set the autoUpgradeProfile property: The auto upgrade configuration.
     *
     * @param autoUpgradeProfile the autoUpgradeProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAutoUpgradeProfile(ManagedClusterAutoUpgradeProfile autoUpgradeProfile) {
        this.autoUpgradeProfile = autoUpgradeProfile;
        return this;
    }

    /**
     * Get the autoScalerProfile property: Parameters to be applied to the cluster-autoscaler when enabled.
     *
     * @return the autoScalerProfile value.
     */
    public ManagedClusterPropertiesAutoScalerProfile autoScalerProfile() {
        return this.autoScalerProfile;
    }

    /**
     * Set the autoScalerProfile property: Parameters to be applied to the cluster-autoscaler when enabled.
     *
     * @param autoScalerProfile the autoScalerProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAutoScalerProfile(ManagedClusterPropertiesAutoScalerProfile autoScalerProfile) {
        this.autoScalerProfile = autoScalerProfile;
        return this;
    }

    /**
     * Get the apiServerAccessProfile property: The access profile for managed cluster API server.
     *
     * @return the apiServerAccessProfile value.
     */
    public ManagedClusterApiServerAccessProfile apiServerAccessProfile() {
        return this.apiServerAccessProfile;
    }

    /**
     * Set the apiServerAccessProfile property: The access profile for managed cluster API server.
     *
     * @param apiServerAccessProfile the apiServerAccessProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withApiServerAccessProfile(
        ManagedClusterApiServerAccessProfile apiServerAccessProfile) {
        this.apiServerAccessProfile = apiServerAccessProfile;
        return this;
    }

    /**
     * Get the diskEncryptionSetId property: The Resource ID of the disk encryption set to use for enabling encryption
     * at rest. This is of the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.
     *
     * @return the diskEncryptionSetId value.
     */
    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    /**
     * Set the diskEncryptionSetId property: The Resource ID of the disk encryption set to use for enabling encryption
     * at rest. This is of the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.
     *
     * @param diskEncryptionSetId the diskEncryptionSetId value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    /**
     * Get the identityProfile property: Identities associated with the cluster.
     *
     * @return the identityProfile value.
     */
    public Map<String, UserAssignedIdentity> identityProfile() {
        return this.identityProfile;
    }

    /**
     * Set the identityProfile property: Identities associated with the cluster.
     *
     * @param identityProfile the identityProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withIdentityProfile(Map<String, UserAssignedIdentity> identityProfile) {
        this.identityProfile = identityProfile;
        return this;
    }

    /**
     * Get the privateLinkResources property: Private link resources associated with the cluster.
     *
     * @return the privateLinkResources value.
     */
    public List<PrivateLinkResourceInner> privateLinkResources() {
        return this.privateLinkResources;
    }

    /**
     * Set the privateLinkResources property: Private link resources associated with the cluster.
     *
     * @param privateLinkResources the privateLinkResources value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withPrivateLinkResources(List<PrivateLinkResourceInner> privateLinkResources) {
        this.privateLinkResources = privateLinkResources;
        return this;
    }

    /**
     * Get the disableLocalAccounts property: If local accounts should be disabled on the Managed Cluster. If set to
     * true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters
     * that are AAD enabled. For more details see [disable local
     * accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     *
     * @return the disableLocalAccounts value.
     */
    public Boolean disableLocalAccounts() {
        return this.disableLocalAccounts;
    }

    /**
     * Set the disableLocalAccounts property: If local accounts should be disabled on the Managed Cluster. If set to
     * true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters
     * that are AAD enabled. For more details see [disable local
     * accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     *
     * @param disableLocalAccounts the disableLocalAccounts value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withDisableLocalAccounts(Boolean disableLocalAccounts) {
        this.disableLocalAccounts = disableLocalAccounts;
        return this;
    }

    /**
     * Get the httpProxyConfig property: Configurations for provisioning the cluster with HTTP proxy servers.
     *
     * @return the httpProxyConfig value.
     */
    public ManagedClusterHttpProxyConfig httpProxyConfig() {
        return this.httpProxyConfig;
    }

    /**
     * Set the httpProxyConfig property: Configurations for provisioning the cluster with HTTP proxy servers.
     *
     * @param httpProxyConfig the httpProxyConfig value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withHttpProxyConfig(ManagedClusterHttpProxyConfig httpProxyConfig) {
        this.httpProxyConfig = httpProxyConfig;
        return this;
    }

    /**
     * Get the securityProfile property: Security profile for the managed cluster.
     *
     * @return the securityProfile value.
     */
    public ManagedClusterSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: Security profile for the managed cluster.
     *
     * @param securityProfile the securityProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withSecurityProfile(ManagedClusterSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the storageProfile property: Storage profile for the managed cluster.
     *
     * @return the storageProfile value.
     */
    public ManagedClusterStorageProfile storageProfile() {
        return this.storageProfile;
    }

    /**
     * Set the storageProfile property: Storage profile for the managed cluster.
     *
     * @param storageProfile the storageProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withStorageProfile(ManagedClusterStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: PublicNetworkAccess of the managedCluster Allow or deny public network
     * access for AKS.
     *
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: PublicNetworkAccess of the managedCluster Allow or deny public network
     * access for AKS.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (powerState() != null) {
            powerState().validate();
        }
        if (agentPoolProfiles() != null) {
            agentPoolProfiles().forEach(e -> e.validate());
        }
        if (linuxProfile() != null) {
            linuxProfile().validate();
        }
        if (windowsProfile() != null) {
            windowsProfile().validate();
        }
        if (servicePrincipalProfile() != null) {
            servicePrincipalProfile().validate();
        }
        if (addonProfiles() != null) {
            addonProfiles()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
        if (podIdentityProfile() != null) {
            podIdentityProfile().validate();
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (aadProfile() != null) {
            aadProfile().validate();
        }
        if (autoUpgradeProfile() != null) {
            autoUpgradeProfile().validate();
        }
        if (autoScalerProfile() != null) {
            autoScalerProfile().validate();
        }
        if (apiServerAccessProfile() != null) {
            apiServerAccessProfile().validate();
        }
        if (identityProfile() != null) {
            identityProfile()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
        if (privateLinkResources() != null) {
            privateLinkResources().forEach(e -> e.validate());
        }
        if (httpProxyConfig() != null) {
            httpProxyConfig().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
        if (storageProfile() != null) {
            storageProfile().validate();
        }
    }
}
