// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.SnapshotType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** A node pool snapshot resource. */
@Fluent
public final class SnapshotInner extends Resource {
    /*
     * Properties of a snapshot.
     */
    @JsonProperty(value = "properties")
    private SnapshotProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy
     * information.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: Properties of a snapshot.
     *
     * @return the innerProperties value.
     */
    private SnapshotProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /** {@inheritDoc} */
    @Override
    public SnapshotInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SnapshotInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the creationData property: CreationData to be used to specify the source agent pool resource ID to create
     * this snapshot.
     *
     * @return the creationData value.
     */
    public CreationData creationData() {
        return this.innerProperties() == null ? null : this.innerProperties().creationData();
    }

    /**
     * Set the creationData property: CreationData to be used to specify the source agent pool resource ID to create
     * this snapshot.
     *
     * @param creationData the creationData value to set.
     * @return the SnapshotInner object itself.
     */
    public SnapshotInner withCreationData(CreationData creationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withCreationData(creationData);
        return this;
    }

    /**
     * Get the snapshotType property: The type of a snapshot. The default is NodePool.
     *
     * @return the snapshotType value.
     */
    public SnapshotType snapshotType() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotType();
    }

    /**
     * Set the snapshotType property: The type of a snapshot. The default is NodePool.
     *
     * @param snapshotType the snapshotType value to set.
     * @return the SnapshotInner object itself.
     */
    public SnapshotInner withSnapshotType(SnapshotType snapshotType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withSnapshotType(snapshotType);
        return this;
    }

    /**
     * Get the kubernetesVersion property: The version of Kubernetes.
     *
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    /**
     * Get the nodeImageVersion property: The version of node image.
     *
     * @return the nodeImageVersion value.
     */
    public String nodeImageVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeImageVersion();
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     *
     * @return the osType value.
     */
    public OSType osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    /**
     * Get the osSku property: Specifies an OS SKU. This value must not be specified if OSType is Windows.
     *
     * @return the osSku value.
     */
    public OSSku osSku() {
        return this.innerProperties() == null ? null : this.innerProperties().osSku();
    }

    /**
     * Get the vmSize property: The size of the VM.
     *
     * @return the vmSize value.
     */
    public String vmSize() {
        return this.innerProperties() == null ? null : this.innerProperties().vmSize();
    }

    /**
     * Get the enableFips property: Whether to use a FIPS-enabled OS.
     *
     * @return the enableFips value.
     */
    public Boolean enableFips() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFips();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
