// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Settings for upgrading an agentpool. */
@Fluent
public final class AgentPoolUpgradeSettings {
    /*
     * The maximum number or percentage of nodes that are surged during
     * upgrade. This can either be set to an integer (e.g. '5') or a percentage
     * (e.g. '50%'). If a percentage is specified, it is the percentage of the
     * total agent pool size at the time of the upgrade. For percentages,
     * fractional nodes are rounded up. If not specified, the default is 1. For
     * more information, including best practices, see:
     * https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
     */
    @JsonProperty(value = "maxSurge")
    private String maxSurge;

    /**
     * Get the maxSurge property: The maximum number or percentage of nodes that are surged during upgrade. This can
     * either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the
     * percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded
     * up. If not specified, the default is 1. For more information, including best practices, see:
     * https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade.
     *
     * @return the maxSurge value.
     */
    public String maxSurge() {
        return this.maxSurge;
    }

    /**
     * Set the maxSurge property: The maximum number or percentage of nodes that are surged during upgrade. This can
     * either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the
     * percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded
     * up. If not specified, the default is 1. For more information, including best practices, see:
     * https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade.
     *
     * @param maxSurge the maxSurge value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withMaxSurge(String maxSurge) {
        this.maxSurge = maxSurge;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
