// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Desired outbound IP resources for the cluster load balancer. */
@Fluent
public final class ManagedClusterLoadBalancerProfileOutboundIPs {
    /*
     * A list of public IP resources.
     */
    @JsonProperty(value = "publicIPs")
    private List<ResourceReference> publicIPs;

    /**
     * Get the publicIPs property: A list of public IP resources.
     *
     * @return the publicIPs value.
     */
    public List<ResourceReference> publicIPs() {
        return this.publicIPs;
    }

    /**
     * Set the publicIPs property: A list of public IP resources.
     *
     * @param publicIPs the publicIPs value to set.
     * @return the ManagedClusterLoadBalancerProfileOutboundIPs object itself.
     */
    public ManagedClusterLoadBalancerProfileOutboundIPs withPublicIPs(List<ResourceReference> publicIPs) {
        this.publicIPs = publicIPs;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publicIPs() != null) {
            publicIPs().forEach(e -> e.validate());
        }
    }
}
