// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Security profile for the container service cluster. */
@Fluent
public final class ManagedClusterSecurityProfile {
    /*
     * Azure Defender settings for the security profile.
     */
    @JsonProperty(value = "azureDefender")
    private ManagedClusterSecurityProfileAzureDefender azureDefender;

    /**
     * Get the azureDefender property: Azure Defender settings for the security profile.
     *
     * @return the azureDefender value.
     */
    public ManagedClusterSecurityProfileAzureDefender azureDefender() {
        return this.azureDefender;
    }

    /**
     * Set the azureDefender property: Azure Defender settings for the security profile.
     *
     * @param azureDefender the azureDefender value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withAzureDefender(ManagedClusterSecurityProfileAzureDefender azureDefender) {
        this.azureDefender = azureDefender;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureDefender() != null) {
            azureDefender().validate();
        }
    }
}
