// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SKU of a Managed Cluster. */
@Fluent
public final class ManagedClusterSku {
    /*
     * The name of a managed cluster SKU.
     */
    @JsonProperty(value = "name")
    private ManagedClusterSkuName name;

    /*
     * The tier of a managed cluster SKU. If not specified, the default is
     * 'Free'. See [uptime
     * SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
     */
    @JsonProperty(value = "tier")
    private ManagedClusterSkuTier tier;

    /**
     * Get the name property: The name of a managed cluster SKU.
     *
     * @return the name value.
     */
    public ManagedClusterSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: The name of a managed cluster SKU.
     *
     * @param name the name value to set.
     * @return the ManagedClusterSku object itself.
     */
    public ManagedClusterSku withName(ManagedClusterSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: The tier of a managed cluster SKU. If not specified, the default is 'Free'. See [uptime
     * SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
     *
     * @return the tier value.
     */
    public ManagedClusterSkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: The tier of a managed cluster SKU. If not specified, the default is 'Free'. See [uptime
     * SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
     *
     * @param tier the tier value to set.
     * @return the ManagedClusterSku object itself.
     */
    public ManagedClusterSku withTier(ManagedClusterSkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
