// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for OSSku. */
public final class OSSku extends ExpandableStringEnum<OSSku> {
    /** Static value Ubuntu for OSSku. */
    public static final OSSku UBUNTU = fromString("Ubuntu");

    /** Static value CBLMariner for OSSku. */
    public static final OSSku CBLMARINER = fromString("CBLMariner");

    /**
     * Creates or finds a OSSku from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OSSku.
     */
    @JsonCreator
    public static OSSku fromString(String name) {
        return fromString(name, OSSku.class);
    }

    /**
     * Gets known OSSku values.
     *
     * @return known OSSku values.
     */
    public static Collection<OSSku> values() {
        return values(OSSku.class);
    }
}
