/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerservice.fluent.ContainerServicesClient;
import com.azure.resourcemanager.containerservice.fluent.models.OrchestratorVersionProfileListResultInner;
import com.azure.resourcemanager.containerservice.implementation.ContainerServiceManagementClientImpl;
import reactor.core.publisher.Mono;

public final class ContainerServicesClientImpl
implements ContainerServicesClient {
    private final ContainerServicesService service;
    private final ContainerServiceManagementClientImpl client;

    ContainerServicesClientImpl(ContainerServiceManagementClientImpl client) {
        this.service = (ContainerServicesService)RestProxy.create(ContainerServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OrchestratorVersionProfileListResultInner>> listOrchestratorsWithResponseAsync(String location, String resourceType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOrchestrators(this.client.getEndpoint(), "2019-08-01", this.client.getSubscriptionId(), location, resourceType, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OrchestratorVersionProfileListResultInner>> listOrchestratorsWithResponseAsync(String location, String resourceType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOrchestrators(this.client.getEndpoint(), "2019-08-01", this.client.getSubscriptionId(), location, resourceType, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OrchestratorVersionProfileListResultInner> listOrchestratorsAsync(String location, String resourceType) {
        return this.listOrchestratorsWithResponseAsync(location, resourceType).flatMap(res -> Mono.justOrEmpty((Object)((OrchestratorVersionProfileListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OrchestratorVersionProfileListResultInner> listOrchestratorsAsync(String location) {
        String resourceType = null;
        return this.listOrchestratorsWithResponseAsync(location, resourceType).flatMap(res -> Mono.justOrEmpty((Object)((OrchestratorVersionProfileListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OrchestratorVersionProfileListResultInner listOrchestrators(String location) {
        String resourceType = null;
        return (OrchestratorVersionProfileListResultInner)this.listOrchestratorsAsync(location, resourceType).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OrchestratorVersionProfileListResultInner> listOrchestratorsWithResponse(String location, String resourceType, Context context) {
        return (Response)this.listOrchestratorsWithResponseAsync(location, resourceType, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerServiceMana")
    private static interface ContainerServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/locations/{location}/orchestrators")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OrchestratorVersionProfileListResultInner>> listOrchestrators(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @QueryParam(value="resource-type") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

