/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ManagedClusterPodIdentityException {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="namespace", required=true)
    private String namespace;
    @JsonProperty(value="podLabels", required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> podLabels;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPodIdentityException.class);

    public String name() {
        return this.name;
    }

    public ManagedClusterPodIdentityException withName(String name) {
        this.name = name;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public ManagedClusterPodIdentityException withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Map<String, String> podLabels() {
        return this.podLabels;
    }

    public ManagedClusterPodIdentityException withPodLabels(Map<String, String> podLabels) {
        this.podLabels = podLabels;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ManagedClusterPodIdentityException"));
        }
        if (this.namespace() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property namespace in model ManagedClusterPodIdentityException"));
        }
        if (this.podLabels() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property podLabels in model ManagedClusterPodIdentityException"));
        }
    }
}

