// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the
 * kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for
 * details.
 */
@Fluent
public final class ManagedClusterAzureMonitorProfileKubeStateMetrics {
    /*
     * Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric
     * (Example: 'namespaces=[k8s-label-1,k8s-label-n,...],pods=[app],...'). By default the metric contains only
     * resource name and namespace labels.
     */
    @JsonProperty(value = "metricLabelsAllowlist")
    private String metricLabelsAllowlist;

    /*
     * Comma-separated list of Kubernetes annotation keys that will be used in the resource's labels metric (Example:
     * 'namespaces=[kubernetes.io/team,...],pods=[kubernetes.io/team],...'). By default the metric contains only
     * resource name and namespace labels.
     */
    @JsonProperty(value = "metricAnnotationsAllowList")
    private String metricAnnotationsAllowList;

    /** Creates an instance of ManagedClusterAzureMonitorProfileKubeStateMetrics class. */
    public ManagedClusterAzureMonitorProfileKubeStateMetrics() {
    }

    /**
     * Get the metricLabelsAllowlist property: Comma-separated list of additional Kubernetes label keys that will be
     * used in the resource's labels metric (Example: 'namespaces=[k8s-label-1,k8s-label-n,...],pods=[app],...'). By
     * default the metric contains only resource name and namespace labels.
     *
     * @return the metricLabelsAllowlist value.
     */
    public String metricLabelsAllowlist() {
        return this.metricLabelsAllowlist;
    }

    /**
     * Set the metricLabelsAllowlist property: Comma-separated list of additional Kubernetes label keys that will be
     * used in the resource's labels metric (Example: 'namespaces=[k8s-label-1,k8s-label-n,...],pods=[app],...'). By
     * default the metric contains only resource name and namespace labels.
     *
     * @param metricLabelsAllowlist the metricLabelsAllowlist value to set.
     * @return the ManagedClusterAzureMonitorProfileKubeStateMetrics object itself.
     */
    public ManagedClusterAzureMonitorProfileKubeStateMetrics withMetricLabelsAllowlist(String metricLabelsAllowlist) {
        this.metricLabelsAllowlist = metricLabelsAllowlist;
        return this;
    }

    /**
     * Get the metricAnnotationsAllowList property: Comma-separated list of Kubernetes annotation keys that will be used
     * in the resource's labels metric (Example: 'namespaces=[kubernetes.io/team,...],pods=[kubernetes.io/team],...').
     * By default the metric contains only resource name and namespace labels.
     *
     * @return the metricAnnotationsAllowList value.
     */
    public String metricAnnotationsAllowList() {
        return this.metricAnnotationsAllowList;
    }

    /**
     * Set the metricAnnotationsAllowList property: Comma-separated list of Kubernetes annotation keys that will be used
     * in the resource's labels metric (Example: 'namespaces=[kubernetes.io/team,...],pods=[kubernetes.io/team],...').
     * By default the metric contains only resource name and namespace labels.
     *
     * @param metricAnnotationsAllowList the metricAnnotationsAllowList value to set.
     * @return the ManagedClusterAzureMonitorProfileKubeStateMetrics object itself.
     */
    public ManagedClusterAzureMonitorProfileKubeStateMetrics withMetricAnnotationsAllowList(
        String metricAnnotationsAllowList) {
        this.metricAnnotationsAllowList = metricAnnotationsAllowList;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
