// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents an OpenShift router. */
@Fluent
public final class OpenShiftRouterProfile {
    /*
     * Name of the router profile.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * DNS subdomain for OpenShift router.
     */
    @JsonProperty(value = "publicSubdomain", access = JsonProperty.Access.WRITE_ONLY)
    private String publicSubdomain;

    /*
     * Auto-allocated FQDN for the OpenShift router.
     */
    @JsonProperty(value = "fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /** Creates an instance of OpenShiftRouterProfile class. */
    public OpenShiftRouterProfile() {
    }

    /**
     * Get the name property: Name of the router profile.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the router profile.
     *
     * @param name the name value to set.
     * @return the OpenShiftRouterProfile object itself.
     */
    public OpenShiftRouterProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the publicSubdomain property: DNS subdomain for OpenShift router.
     *
     * @return the publicSubdomain value.
     */
    public String publicSubdomain() {
        return this.publicSubdomain;
    }

    /**
     * Get the fqdn property: Auto-allocated FQDN for the OpenShift router.
     *
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
