/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerservice.fluent.AgentPoolsClient;
import com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.azure.resourcemanager.containerservice.fluent.ContainerServicesClient;
import com.azure.resourcemanager.containerservice.fluent.MaintenanceConfigurationsClient;
import com.azure.resourcemanager.containerservice.fluent.ManagedClustersClient;
import com.azure.resourcemanager.containerservice.fluent.OpenShiftManagedClustersClient;
import com.azure.resourcemanager.containerservice.fluent.OperationsClient;
import com.azure.resourcemanager.containerservice.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.containerservice.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.containerservice.fluent.ResolvePrivateLinkServiceIdsClient;
import com.azure.resourcemanager.containerservice.implementation.AgentPoolsClientImpl;
import com.azure.resourcemanager.containerservice.implementation.ContainerServicesClientImpl;
import com.azure.resourcemanager.containerservice.implementation.MaintenanceConfigurationsClientImpl;
import com.azure.resourcemanager.containerservice.implementation.ManagedClustersClientImpl;
import com.azure.resourcemanager.containerservice.implementation.OpenShiftManagedClustersClientImpl;
import com.azure.resourcemanager.containerservice.implementation.OperationsClientImpl;
import com.azure.resourcemanager.containerservice.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.containerservice.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.containerservice.implementation.ResolvePrivateLinkServiceIdsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

public final class ContainerServiceManagementClientImpl
extends AzureServiceClient
implements ContainerServiceManagementClient {
    private final ClientLogger logger = new ClientLogger(ContainerServiceManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final ManagedClustersClient managedClusters;
    private final MaintenanceConfigurationsClient maintenanceConfigurations;
    private final AgentPoolsClient agentPools;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final ResolvePrivateLinkServiceIdsClient resolvePrivateLinkServiceIds;
    private final OpenShiftManagedClustersClient openShiftManagedClusters;
    private final ContainerServicesClient containerServices;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ManagedClustersClient getManagedClusters() {
        return this.managedClusters;
    }

    @Override
    public MaintenanceConfigurationsClient getMaintenanceConfigurations() {
        return this.maintenanceConfigurations;
    }

    @Override
    public AgentPoolsClient getAgentPools() {
        return this.agentPools;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public ResolvePrivateLinkServiceIdsClient getResolvePrivateLinkServiceIds() {
        return this.resolvePrivateLinkServiceIds;
    }

    @Override
    public OpenShiftManagedClustersClient getOpenShiftManagedClusters() {
        return this.openShiftManagedClusters;
    }

    @Override
    public ContainerServicesClient getContainerServices() {
        return this.containerServices;
    }

    ContainerServiceManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.operations = new OperationsClientImpl(this);
        this.managedClusters = new ManagedClustersClientImpl(this);
        this.maintenanceConfigurations = new MaintenanceConfigurationsClientImpl(this);
        this.agentPools = new AgentPoolsClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.resolvePrivateLinkServiceIds = new ResolvePrivateLinkServiceIdsClientImpl(this);
        this.openShiftManagedClusters = new OpenShiftManagedClustersClientImpl(this);
        this.containerServices = new ContainerServicesClientImpl(this);
    }
}

