/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.ContainerServiceManager;
import com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateEndpointConnectionListResultInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.containerservice.fluent.models.PrivateLinkResourcesListResultInner;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterAgentPoolImpl;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClusterNetworkProfileImpl;
import com.azure.resourcemanager.containerservice.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceSshConfiguration;
import com.azure.resourcemanager.containerservice.models.ContainerServiceSshPublicKey;
import com.azure.resourcemanager.containerservice.models.CredentialResult;
import com.azure.resourcemanager.containerservice.models.KubernetesCluster;
import com.azure.resourcemanager.containerservice.models.KubernetesClusterAgentPool;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAddonProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterApiServerAccessProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpoint;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnection;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class KubernetesClusterImpl
extends GroupableResourceImpl<KubernetesCluster, ManagedClusterInner, KubernetesClusterImpl, ContainerServiceManager>
implements KubernetesCluster,
KubernetesCluster.Definition,
KubernetesCluster.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private List<CredentialResult> adminKubeConfigs;
    private List<CredentialResult> userKubeConfigs;

    protected KubernetesClusterImpl(String name, ManagedClusterInner innerObject, ContainerServiceManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        if (((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withAgentPoolProfiles(new ArrayList<ManagedClusterAgentPoolProfile>());
        }
        this.adminKubeConfigs = null;
        this.userKubeConfigs = null;
    }

    @Override
    public String provisioningState() {
        return ((ManagedClusterInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public String dnsPrefix() {
        return ((ManagedClusterInner)((Object)this.innerModel())).dnsPrefix();
    }

    @Override
    public String fqdn() {
        return ((ManagedClusterInner)((Object)this.innerModel())).fqdn();
    }

    @Override
    public String version() {
        return ((ManagedClusterInner)((Object)this.innerModel())).kubernetesVersion();
    }

    @Override
    public List<CredentialResult> adminKubeConfigs() {
        if (this.adminKubeConfigs == null || this.adminKubeConfigs.size() == 0) {
            this.adminKubeConfigs = ((ContainerServiceManager)this.manager()).kubernetesClusters().listAdminKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return Collections.unmodifiableList(this.adminKubeConfigs);
    }

    @Override
    public List<CredentialResult> userKubeConfigs() {
        if (this.userKubeConfigs == null || this.userKubeConfigs.size() == 0) {
            this.userKubeConfigs = ((ContainerServiceManager)this.manager()).kubernetesClusters().listUserKubeConfigContent(this.resourceGroupName(), this.name());
        }
        return Collections.unmodifiableList(this.userKubeConfigs);
    }

    @Override
    public byte[] adminKubeConfigContent() {
        Iterator<CredentialResult> iterator = this.adminKubeConfigs().iterator();
        if (iterator.hasNext()) {
            CredentialResult config = iterator.next();
            return config.value();
        }
        return new byte[0];
    }

    @Override
    public byte[] userKubeConfigContent() {
        Iterator<CredentialResult> iterator = this.userKubeConfigs().iterator();
        if (iterator.hasNext()) {
            CredentialResult config = iterator.next();
            return config.value();
        }
        return new byte[0];
    }

    @Override
    public String servicePrincipalClientId() {
        if (((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile().clientId();
        }
        return null;
    }

    @Override
    public String servicePrincipalSecret() {
        if (((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile() != null) {
            return ((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile().secret();
        }
        return null;
    }

    @Override
    public String linuxRootUsername() {
        if (((ManagedClusterInner)((Object)this.innerModel())).linuxProfile() != null) {
            return ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().adminUsername();
        }
        return null;
    }

    @Override
    public String sshKey() {
        if (((ManagedClusterInner)((Object)this.innerModel())).linuxProfile() == null || ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh() == null || ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys() == null || ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys().size() == 0) {
            return null;
        }
        return ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys().get(0).keyData();
    }

    @Override
    public Map<String, KubernetesClusterAgentPool> agentPools() {
        HashMap<String, KubernetesClusterAgentPoolImpl> agentPoolMap = new HashMap<String, KubernetesClusterAgentPoolImpl>();
        if (((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles() != null && ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles().size() > 0) {
            for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles()) {
                agentPoolMap.put(agentPoolProfile.name(), new KubernetesClusterAgentPoolImpl(agentPoolProfile, this));
            }
        }
        return Collections.unmodifiableMap(agentPoolMap);
    }

    @Override
    public ContainerServiceNetworkProfile networkProfile() {
        return ((ManagedClusterInner)((Object)this.innerModel())).networkProfile();
    }

    @Override
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return Collections.unmodifiableMap(((ManagedClusterInner)((Object)this.innerModel())).addonProfiles());
    }

    @Override
    public String nodeResourceGroup() {
        return ((ManagedClusterInner)((Object)this.innerModel())).nodeResourceGroup();
    }

    @Override
    public boolean enableRBAC() {
        return ((ManagedClusterInner)((Object)this.innerModel())).enableRbac();
    }

    private Mono<List<CredentialResult>> listAdminConfig(KubernetesClusterImpl self) {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().listAdminKubeConfigContentAsync(self.resourceGroupName(), self.name()).map(kubeConfigs -> {
            self.adminKubeConfigs = kubeConfigs;
            return self.adminKubeConfigs;
        });
    }

    private Mono<List<CredentialResult>> listUserConfig(KubernetesClusterImpl self) {
        return ((ContainerServiceManager)this.manager()).kubernetesClusters().listUserKubeConfigContentAsync(self.resourceGroupName(), self.name()).map(kubeConfigs -> {
            self.userKubeConfigs = kubeConfigs;
            return self.userKubeConfigs;
        });
    }

    protected Mono<ManagedClusterInner> getInnerAsync() {
        KubernetesClusterImpl self = this;
        Mono<List<CredentialResult>> adminConfig = this.listAdminConfig(self);
        Mono<List<CredentialResult>> userConfig = this.listUserConfig(self);
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().getByResourceGroupAsync(this.resourceGroupName(), this.name()).flatMap(managedClusterInner -> Flux.merge((Publisher[])new Publisher[]{adminConfig, userConfig}).last().map(bytes -> managedClusterInner));
    }

    public Mono<KubernetesCluster> createResourceAsync() {
        KubernetesClusterImpl self = this;
        if (!this.isInCreateMode()) {
            ((ManagedClusterInner)((Object)this.innerModel())).withServicePrincipalProfile(null);
        }
        Mono<List<CredentialResult>> adminConfig = this.listAdminConfig(self);
        Mono<List<CredentialResult>> userConfig = this.listUserConfig(self);
        return ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getManagedClusters().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ManagedClusterInner)((Object)self.innerModel())).flatMap(inner -> Flux.merge((Publisher[])new Publisher[]{adminConfig, userConfig}).last().map(bytes -> {
            self.setInner(inner);
            return self;
        }));
    }

    @Override
    public KubernetesClusterImpl withVersion(String kubernetesVersion) {
        ((ManagedClusterInner)((Object)this.innerModel())).withKubernetesVersion(kubernetesVersion);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDefaultVersion() {
        ((ManagedClusterInner)((Object)this.innerModel())).withKubernetesVersion("");
        return this;
    }

    @Override
    public KubernetesClusterImpl withRootUsername(String rootUserName) {
        if (((ManagedClusterInner)((Object)this.innerModel())).linuxProfile() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withLinuxProfile(new ContainerServiceLinuxProfile());
        }
        ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public KubernetesClusterImpl withSshKey(String sshKeyData) {
        ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().withSsh(new ContainerServiceSshConfiguration().withPublicKeys(new ArrayList<ContainerServiceSshPublicKey>()));
        ((ManagedClusterInner)((Object)this.innerModel())).linuxProfile().ssh().publicKeys().add(new ContainerServiceSshPublicKey().withKeyData(sshKeyData));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalClientId(String clientId) {
        ((ManagedClusterInner)((Object)this.innerModel())).withServicePrincipalProfile(new ManagedClusterServicePrincipalProfile().withClientId(clientId));
        return this;
    }

    @Override
    public KubernetesClusterImpl withServicePrincipalSecret(String secret) {
        ((ManagedClusterInner)((Object)this.innerModel())).servicePrincipalProfile().withSecret(secret);
        return this;
    }

    @Override
    public KubernetesClusterImpl withDnsPrefix(String dnsPrefix) {
        ((ManagedClusterInner)((Object)this.innerModel())).withDnsPrefix(dnsPrefix);
        return this;
    }

    public KubernetesClusterAgentPoolImpl defineAgentPool(String name) {
        ManagedClusterAgentPoolProfile innerPoolProfile = new ManagedClusterAgentPoolProfile();
        innerPoolProfile.withName(name);
        return new KubernetesClusterAgentPoolImpl(innerPoolProfile, this);
    }

    public KubernetesClusterAgentPoolImpl updateAgentPool(String name) {
        for (ManagedClusterAgentPoolProfile agentPoolProfile : ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles()) {
            if (!agentPoolProfile.name().equals(name)) continue;
            return new KubernetesClusterAgentPoolImpl(agentPoolProfile, this);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Cannot get agent pool named %s", name)));
    }

    @Override
    public KubernetesCluster.DefinitionStages.NetworkProfileDefinitionStages.Blank<KubernetesCluster.DefinitionStages.WithCreate> defineNetworkProfile() {
        return new KubernetesClusterNetworkProfileImpl(this);
    }

    @Override
    public KubernetesClusterImpl withAddOnProfiles(Map<String, ManagedClusterAddonProfile> addOnProfileMap) {
        ((ManagedClusterInner)((Object)this.innerModel())).withAddonProfiles(addOnProfileMap);
        return this;
    }

    @Override
    public KubernetesClusterImpl withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        ((ManagedClusterInner)((Object)this.innerModel())).withNetworkProfile(networkProfile);
        return this;
    }

    @Override
    public KubernetesClusterImpl withRBACEnabled() {
        ((ManagedClusterInner)((Object)this.innerModel())).withEnableRbac(true);
        return this;
    }

    @Override
    public KubernetesClusterImpl withRBACDisabled() {
        ((ManagedClusterInner)((Object)this.innerModel())).withEnableRbac(false);
        return this;
    }

    public KubernetesClusterImpl addNewAgentPool(KubernetesClusterAgentPoolImpl agentPool) {
        if (!this.isInCreateMode()) {
            this.addDependency(context -> ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getAgentPools().createOrUpdateAsync(this.resourceGroupName(), this.name(), agentPool.name(), agentPool.getAgentPoolInner()).then(context.voidMono()));
        }
        ((ManagedClusterInner)((Object)this.innerModel())).agentPoolProfiles().add((ManagedClusterAgentPoolProfile)agentPool.innerModel());
        return this;
    }

    @Override
    public KubernetesClusterImpl enablePrivateCluster() {
        if (((ManagedClusterInner)((Object)this.innerModel())).apiServerAccessProfile() == null) {
            ((ManagedClusterInner)((Object)this.innerModel())).withApiServerAccessProfile(new ManagedClusterApiServerAccessProfile());
        }
        ((ManagedClusterInner)((Object)this.innerModel())).apiServerAccessProfile().withEnablePrivateCluster(true);
        return this;
    }

    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable(this.listPrivateLinkResourcesAsync());
    }

    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        Mono retList = ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getPrivateLinkResources().listWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateLinkResourcesListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)x$0)).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    public PagedIterable<PrivateEndpointConnection> listPrivateEndpointConnections() {
        return new PagedIterable(this.listPrivateEndpointConnectionsAsync());
    }

    public PagedFlux<PrivateEndpointConnection> listPrivateEndpointConnectionsAsync() {
        Mono retList = ((ContainerServiceManagementClient)((ContainerServiceManager)this.manager()).serviceClient()).getPrivateEndpointConnections().listWithResponseAsync(this.resourceGroupName(), this.name()).map(response -> new SimpleResponse(response, ((PrivateEndpointConnectionListResultInner)response.getValue()).value().stream().map(x$0 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)((Object)x$0)))).collect(Collectors.toList())));
        return PagedConverter.convertListToPagedFlux((Mono)retList);
    }

    private static final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection {
        private final PrivateEndpointConnectionInner innerModel;
        private final PrivateEndpoint privateEndpoint;
        private final PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
        private final PrivateEndpointConnectionProvisioningState provisioningState;

        private PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerModel) {
            this.innerModel = innerModel;
            PrivateEndpoint privateEndpoint = this.privateEndpoint = innerModel.privateEndpoint() == null ? null : new PrivateEndpoint(innerModel.privateEndpoint().id());
            this.privateLinkServiceConnectionState = innerModel.privateLinkServiceConnectionState() == null ? null : new PrivateLinkServiceConnectionState(innerModel.privateLinkServiceConnectionState().status() == null ? null : PrivateEndpointServiceConnectionStatus.fromString((String)innerModel.privateLinkServiceConnectionState().status().toString()), innerModel.privateLinkServiceConnectionState().description(), "");
            this.provisioningState = innerModel.provisioningState() == null ? null : PrivateEndpointConnectionProvisioningState.fromString((String)innerModel.provisioningState().toString());
        }

        public String id() {
            return this.innerModel.id();
        }

        public String name() {
            return this.innerModel.name();
        }

        public String type() {
            return this.innerModel.type();
        }

        public PrivateEndpoint privateEndpoint() {
            return this.privateEndpoint;
        }

        public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
            return this.privateLinkServiceConnectionState;
        }

        public PrivateEndpointConnectionProvisioningState provisioningState() {
            return this.provisioningState;
        }
    }

    private static final class PrivateLinkResourceImpl
    implements PrivateLinkResource {
        private final PrivateLinkResourceInner innerModel;

        private PrivateLinkResourceImpl(PrivateLinkResourceInner innerModel) {
            this.innerModel = innerModel;
        }

        public String groupId() {
            return this.innerModel.groupId();
        }

        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        public List<String> requiredDnsZoneNames() {
            return Collections.emptyList();
        }
    }
}

