// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.containerservice.models.MeshUpgradeProfileProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Upgrade profile for given mesh.
 */
@Fluent
public final class MeshUpgradeProfileInner extends ProxyResource {
    /*
     * Mesh upgrade profile properties for a major.minor release.
     */
    @JsonProperty(value = "properties")
    private MeshUpgradeProfileProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of MeshUpgradeProfileInner class.
     */
    public MeshUpgradeProfileInner() {
    }

    /**
     * Get the properties property: Mesh upgrade profile properties for a major.minor release.
     * 
     * @return the properties value.
     */
    public MeshUpgradeProfileProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Mesh upgrade profile properties for a major.minor release.
     * 
     * @param properties the properties value to set.
     * @return the MeshUpgradeProfileInner object itself.
     */
    public MeshUpgradeProfileInner withProperties(MeshUpgradeProfileProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
