// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.containerservice.models.TrustedAccessRoleRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Trusted access role definition.
 */
@Immutable
public final class TrustedAccessRoleInner {
    /*
     * Resource type of Azure resource
     */
    @JsonProperty(value = "sourceResourceType", access = JsonProperty.Access.WRITE_ONLY)
    private String sourceResourceType;

    /*
     * Name of role, name is unique under a source resource type
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * List of rules for the role. This maps to 'rules' property of [Kubernetes Cluster
     * Role](https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/cluster-role-v1/#ClusterRole).
     */
    @JsonProperty(value = "rules", access = JsonProperty.Access.WRITE_ONLY)
    private List<TrustedAccessRoleRule> rules;

    /**
     * Creates an instance of TrustedAccessRoleInner class.
     */
    public TrustedAccessRoleInner() {
    }

    /**
     * Get the sourceResourceType property: Resource type of Azure resource.
     * 
     * @return the sourceResourceType value.
     */
    public String sourceResourceType() {
        return this.sourceResourceType;
    }

    /**
     * Get the name property: Name of role, name is unique under a source resource type.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the rules property: List of rules for the role. This maps to 'rules' property of [Kubernetes Cluster
     * Role](https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/cluster-role-v1/#ClusterRole).
     * 
     * @return the rules value.
     */
    public List<TrustedAccessRoleRule> rules() {
        return this.rules;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }
}
