// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The type of Agent Pool.
 */
public final class AgentPoolType extends ExpandableStringEnum<AgentPoolType> {
    /**
     * Static value VirtualMachineScaleSets for AgentPoolType.
     */
    public static final AgentPoolType VIRTUAL_MACHINE_SCALE_SETS = fromString("VirtualMachineScaleSets");

    /**
     * Static value AvailabilitySet for AgentPoolType.
     */
    public static final AgentPoolType AVAILABILITY_SET = fromString("AvailabilitySet");

    /**
     * Creates a new instance of AgentPoolType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AgentPoolType() {
    }

    /**
     * Creates or finds a AgentPoolType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AgentPoolType.
     */
    @JsonCreator
    public static AgentPoolType fromString(String name) {
        return fromString(name, AgentPoolType.class);
    }

    /**
     * Gets known AgentPoolType values.
     * 
     * @return known AgentPoolType values.
     */
    public static Collection<AgentPoolType> values() {
        return values(AgentPoolType.class);
    }
}
