// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Windows agent pool's specific profile.
 */
@Fluent
public final class AgentPoolWindowsProfile {
    /*
     * The default value is false. Outbound NAT can only be disabled if the cluster outboundType is NAT Gateway and the
     * Windows agent pool does not have node public IP enabled.
     */
    @JsonProperty(value = "disableOutboundNat")
    private Boolean disableOutboundNat;

    /**
     * Creates an instance of AgentPoolWindowsProfile class.
     */
    public AgentPoolWindowsProfile() {
    }

    /**
     * Get the disableOutboundNat property: The default value is false. Outbound NAT can only be disabled if the cluster
     * outboundType is NAT Gateway and the Windows agent pool does not have node public IP enabled.
     * 
     * @return the disableOutboundNat value.
     */
    public Boolean disableOutboundNat() {
        return this.disableOutboundNat;
    }

    /**
     * Set the disableOutboundNat property: The default value is false. Outbound NAT can only be disabled if the cluster
     * outboundType is NAT Gateway and the Windows agent pool does not have node public IP enabled.
     * 
     * @param disableOutboundNat the disableOutboundNat value to set.
     * @return the AgentPoolWindowsProfile object itself.
     */
    public AgentPoolWindowsProfile withDisableOutboundNat(Boolean disableOutboundNat) {
        this.disableOutboundNat = disableOutboundNat;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
