// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Istio Service Mesh Certificate Authority (CA) configuration. For now, we only support plugin certificates as
 * described here https://aka.ms/asm-plugin-ca.
 */
@Fluent
public final class IstioCertificateAuthority {
    /*
     * Plugin certificates information for Service Mesh.
     */
    @JsonProperty(value = "plugin")
    private IstioPluginCertificateAuthority plugin;

    /**
     * Creates an instance of IstioCertificateAuthority class.
     */
    public IstioCertificateAuthority() {
    }

    /**
     * Get the plugin property: Plugin certificates information for Service Mesh.
     * 
     * @return the plugin value.
     */
    public IstioPluginCertificateAuthority plugin() {
        return this.plugin;
    }

    /**
     * Set the plugin property: Plugin certificates information for Service Mesh.
     * 
     * @param plugin the plugin value to set.
     * @return the IstioCertificateAuthority object itself.
     */
    public IstioCertificateAuthority withPlugin(IstioPluginCertificateAuthority plugin) {
        this.plugin = plugin;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (plugin() != null) {
            plugin().validate();
        }
    }
}
