// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Istio components configuration.
 */
@Fluent
public final class IstioComponents {
    /*
     * Istio ingress gateways.
     */
    @JsonProperty(value = "ingressGateways")
    private List<IstioIngressGateway> ingressGateways;

    /*
     * Istio egress gateways.
     */
    @JsonProperty(value = "egressGateways")
    private List<IstioEgressGateway> egressGateways;

    /**
     * Creates an instance of IstioComponents class.
     */
    public IstioComponents() {
    }

    /**
     * Get the ingressGateways property: Istio ingress gateways.
     * 
     * @return the ingressGateways value.
     */
    public List<IstioIngressGateway> ingressGateways() {
        return this.ingressGateways;
    }

    /**
     * Set the ingressGateways property: Istio ingress gateways.
     * 
     * @param ingressGateways the ingressGateways value to set.
     * @return the IstioComponents object itself.
     */
    public IstioComponents withIngressGateways(List<IstioIngressGateway> ingressGateways) {
        this.ingressGateways = ingressGateways;
        return this;
    }

    /**
     * Get the egressGateways property: Istio egress gateways.
     * 
     * @return the egressGateways value.
     */
    public List<IstioEgressGateway> egressGateways() {
        return this.egressGateways;
    }

    /**
     * Set the egressGateways property: Istio egress gateways.
     * 
     * @param egressGateways the egressGateways value to set.
     * @return the IstioComponents object itself.
     */
    public IstioComponents withEgressGateways(List<IstioEgressGateway> egressGateways) {
        this.egressGateways = egressGateways;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ingressGateways() != null) {
            ingressGateways().forEach(e -> e.validate());
        }
        if (egressGateways() != null) {
            egressGateways().forEach(e -> e.validate());
        }
    }
}
