// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Istio service mesh configuration.
 */
@Fluent
public final class IstioServiceMesh {
    /*
     * Istio components configuration.
     */
    @JsonProperty(value = "components")
    private IstioComponents components;

    /*
     * Istio Service Mesh Certificate Authority (CA) configuration. For now, we only support plugin certificates as
     * described here https://aka.ms/asm-plugin-ca
     */
    @JsonProperty(value = "certificateAuthority")
    private IstioCertificateAuthority certificateAuthority;

    /*
     * The list of revisions of the Istio control plane. When an upgrade is not in progress, this holds one value. When
     * canary upgrade is in progress, this can only hold two consecutive values. For more information, see:
     * https://learn.microsoft.com/en-us/azure/aks/istio-upgrade
     */
    @JsonProperty(value = "revisions")
    private List<String> revisions;

    /**
     * Creates an instance of IstioServiceMesh class.
     */
    public IstioServiceMesh() {
    }

    /**
     * Get the components property: Istio components configuration.
     *
     * @return the components value.
     */
    public IstioComponents components() {
        return this.components;
    }

    /**
     * Set the components property: Istio components configuration.
     *
     * @param components the components value to set.
     * @return the IstioServiceMesh object itself.
     */
    public IstioServiceMesh withComponents(IstioComponents components) {
        this.components = components;
        return this;
    }

    /**
     * Get the certificateAuthority property: Istio Service Mesh Certificate Authority (CA) configuration. For now, we
     * only support plugin certificates as described here https://aka.ms/asm-plugin-ca.
     *
     * @return the certificateAuthority value.
     */
    public IstioCertificateAuthority certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Set the certificateAuthority property: Istio Service Mesh Certificate Authority (CA) configuration. For now, we
     * only support plugin certificates as described here https://aka.ms/asm-plugin-ca.
     *
     * @param certificateAuthority the certificateAuthority value to set.
     * @return the IstioServiceMesh object itself.
     */
    public IstioServiceMesh withCertificateAuthority(IstioCertificateAuthority certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    /**
     * Get the revisions property: The list of revisions of the Istio control plane. When an upgrade is not in progress,
     * this holds one value. When canary upgrade is in progress, this can only hold two consecutive values. For more
     * information, see: https://learn.microsoft.com/en-us/azure/aks/istio-upgrade.
     *
     * @return the revisions value.
     */
    public List<String> revisions() {
        return this.revisions;
    }

    /**
     * Set the revisions property: The list of revisions of the Istio control plane. When an upgrade is not in progress,
     * this holds one value. When canary upgrade is in progress, this can only hold two consecutive values. For more
     * information, see: https://learn.microsoft.com/en-us/azure/aks/istio-upgrade.
     *
     * @param revisions the revisions value to set.
     * @return the IstioServiceMesh object itself.
     */
    public IstioServiceMesh withRevisions(List<String> revisions) {
        this.revisions = revisions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (components() != null) {
            components().validate();
        }
        if (certificateAuthority() != null) {
            certificateAuthority().validate();
        }
    }
}
