// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Ingress profile for the container service cluster.
 */
@Fluent
public final class ManagedClusterIngressProfile {
    /*
     * App Routing settings for the ingress profile. You can find an overview and onboarding guide for this feature at
     * https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
     */
    @JsonProperty(value = "webAppRouting")
    private ManagedClusterIngressProfileWebAppRouting webAppRouting;

    /**
     * Creates an instance of ManagedClusterIngressProfile class.
     */
    public ManagedClusterIngressProfile() {
    }

    /**
     * Get the webAppRouting property: App Routing settings for the ingress profile. You can find an overview and
     * onboarding guide for this feature at
     * https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
     * 
     * @return the webAppRouting value.
     */
    public ManagedClusterIngressProfileWebAppRouting webAppRouting() {
        return this.webAppRouting;
    }

    /**
     * Set the webAppRouting property: App Routing settings for the ingress profile. You can find an overview and
     * onboarding guide for this feature at
     * https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
     * 
     * @param webAppRouting the webAppRouting value to set.
     * @return the ManagedClusterIngressProfile object itself.
     */
    public ManagedClusterIngressProfile withWebAppRouting(ManagedClusterIngressProfileWebAppRouting webAppRouting) {
        this.webAppRouting = webAppRouting;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (webAppRouting() != null) {
            webAppRouting().validate();
        }
    }
}
