// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerservice.fluent.models.OpenShiftManagedClusterInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The response from the List OpenShift Managed Clusters operation.
 */
@Fluent
public final class OpenShiftManagedClusterListResult {
    /*
     * The list of OpenShift managed clusters.
     */
    @JsonProperty(value = "value")
    private List<OpenShiftManagedClusterInner> value;

    /*
     * The URL to get the next set of OpenShift managed cluster results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Creates an instance of OpenShiftManagedClusterListResult class.
     */
    public OpenShiftManagedClusterListResult() {
    }

    /**
     * Get the value property: The list of OpenShift managed clusters.
     * 
     * @return the value value.
     */
    public List<OpenShiftManagedClusterInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of OpenShift managed clusters.
     * 
     * @param value the value value to set.
     * @return the OpenShiftManagedClusterListResult object itself.
     */
    public OpenShiftManagedClusterListResult withValue(List<OpenShiftManagedClusterInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of OpenShift managed cluster results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
