// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Service mesh profile for a managed cluster.
 */
@Fluent
public final class ServiceMeshProfile {
    /*
     * Mode of the service mesh.
     */
    @JsonProperty(value = "mode", required = true)
    private ServiceMeshMode mode;

    /*
     * Istio service mesh configuration.
     */
    @JsonProperty(value = "istio")
    private IstioServiceMesh istio;

    /**
     * Creates an instance of ServiceMeshProfile class.
     */
    public ServiceMeshProfile() {
    }

    /**
     * Get the mode property: Mode of the service mesh.
     * 
     * @return the mode value.
     */
    public ServiceMeshMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Mode of the service mesh.
     * 
     * @param mode the mode value to set.
     * @return the ServiceMeshProfile object itself.
     */
    public ServiceMeshProfile withMode(ServiceMeshMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the istio property: Istio service mesh configuration.
     * 
     * @return the istio value.
     */
    public IstioServiceMesh istio() {
        return this.istio;
    }

    /**
     * Set the istio property: Istio service mesh configuration.
     * 
     * @param istio the istio value to set.
     * @return the ServiceMeshProfile object itself.
     */
    public ServiceMeshProfile withIstio(IstioServiceMesh istio) {
        this.istio = istio;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property mode in model ServiceMeshProfile"));
        }
        if (istio() != null) {
            istio().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServiceMeshProfile.class);
}
