// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Time in a week.
 */
@Fluent
public final class TimeInWeek {
    /*
     * The day of the week.
     */
    @JsonProperty(value = "day")
    private WeekDay day;

    /*
     * Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive).
     * 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time
     * range.
     */
    @JsonProperty(value = "hourSlots")
    private List<Integer> hourSlots;

    /**
     * Creates an instance of TimeInWeek class.
     */
    public TimeInWeek() {
    }

    /**
     * Get the day property: The day of the week.
     *
     * @return the day value.
     */
    public WeekDay day() {
        return this.day;
    }

    /**
     * Set the day property: The day of the week.
     *
     * @param day the day value to set.
     * @return the TimeInWeek object itself.
     */
    public TimeInWeek withDay(WeekDay day) {
        this.day = day;
        return this;
    }

    /**
     * Get the hourSlots property: Each integer hour represents a time range beginning at 0m after the hour ending at
     * the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means
     * the 00:00 - 02:00 UTC time range.
     *
     * @return the hourSlots value.
     */
    public List<Integer> hourSlots() {
        return this.hourSlots;
    }

    /**
     * Set the hourSlots property: Each integer hour represents a time range beginning at 0m after the hour ending at
     * the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means
     * the 00:00 - 02:00 UTC time range.
     *
     * @param hourSlots the hourSlots value to set.
     * @return the TimeInWeek object itself.
     */
    public TimeInWeek withHourSlots(List<Integer> hourSlots) {
        this.hourSlots = hourSlots;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
