// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeProfilePropertiesUpgradesItem;
import com.azure.resourcemanager.containerservice.models.OSType;
import java.io.IOException;
import java.util.List;

/**
 * The list of available upgrade versions.
 */
@Fluent
public final class AgentPoolUpgradeProfileProperties implements JsonSerializable<AgentPoolUpgradeProfileProperties> {
    /*
     * The Kubernetes version (major.minor.patch).
     */
    private String kubernetesVersion;

    /*
     * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    private OSType osType;

    /*
     * List of orchestrator types and versions available for upgrade.
     */
    private List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades;

    /*
     * The latest AKS supported node image version.
     */
    private String latestNodeImageVersion;

    /**
     * Creates an instance of AgentPoolUpgradeProfileProperties class.
     */
    public AgentPoolUpgradeProfileProperties() {
    }

    /**
     * Get the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.osType;
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @return the upgrades value.
     */
    public List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @param upgrades the upgrades value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties
        withUpgrades(List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Get the latestNodeImageVersion property: The latest AKS supported node image version.
     * 
     * @return the latestNodeImageVersion value.
     */
    public String latestNodeImageVersion() {
        return this.latestNodeImageVersion;
    }

    /**
     * Set the latestNodeImageVersion property: The latest AKS supported node image version.
     * 
     * @param latestNodeImageVersion the latestNodeImageVersion value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties withLatestNodeImageVersion(String latestNodeImageVersion) {
        this.latestNodeImageVersion = latestNodeImageVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kubernetesVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property kubernetesVersion in model AgentPoolUpgradeProfileProperties"));
        }
        if (osType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property osType in model AgentPoolUpgradeProfileProperties"));
        }
        if (upgrades() != null) {
            upgrades().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolUpgradeProfileProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("latestNodeImageVersion", this.latestNodeImageVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolUpgradeProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolUpgradeProfileProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AgentPoolUpgradeProfileProperties.
     */
    public static AgentPoolUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolUpgradeProfileProperties deserializedAgentPoolUpgradeProfileProperties
                = new AgentPoolUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileProperties.kubernetesVersion = reader.getString();
                } else if ("osType".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileProperties.osType = OSType.fromString(reader.getString());
                } else if ("upgrades".equals(fieldName)) {
                    List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades
                        = reader.readArray(reader1 -> AgentPoolUpgradeProfilePropertiesUpgradesItem.fromJson(reader1));
                    deserializedAgentPoolUpgradeProfileProperties.upgrades = upgrades;
                } else if ("latestNodeImageVersion".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileProperties.latestNodeImageVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolUpgradeProfileProperties;
        });
    }
}
