// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolInner;
import java.io.IOException;
import java.util.List;

/**
 * The response from the List Agent Pools operation.
 */
@Fluent
public final class AgentPoolListResult implements JsonSerializable<AgentPoolListResult> {
    /*
     * The list of agent pools.
     */
    private List<AgentPoolInner> value;

    /*
     * The URL to get the next set of agent pool results.
     */
    private String nextLink;

    /**
     * Creates an instance of AgentPoolListResult class.
     */
    public AgentPoolListResult() {
    }

    /**
     * Get the value property: The list of agent pools.
     * 
     * @return the value value.
     */
    public List<AgentPoolInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of agent pools.
     * 
     * @param value the value value to set.
     * @return the AgentPoolListResult object itself.
     */
    public AgentPoolListResult withValue(List<AgentPoolInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of agent pool results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolListResult.
     */
    public static AgentPoolListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolListResult deserializedAgentPoolListResult = new AgentPoolListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AgentPoolInner> value = reader.readArray(reader1 -> AgentPoolInner.fromJson(reader1));
                    deserializedAgentPoolListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAgentPoolListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolListResult;
        });
    }
}
