// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Mesh upgrade profile properties for a major.minor release.
 */
@Fluent
public final class MeshUpgradeProfileProperties extends MeshRevision {
    /**
     * Creates an instance of MeshUpgradeProfileProperties class.
     */
    public MeshUpgradeProfileProperties() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MeshUpgradeProfileProperties withRevision(String revision) {
        super.withRevision(revision);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MeshUpgradeProfileProperties withUpgrades(List<String> upgrades) {
        super.withUpgrades(upgrades);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MeshUpgradeProfileProperties withCompatibleWith(List<CompatibleVersions> compatibleWith) {
        super.withCompatibleWith(compatibleWith);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revision", revision());
        jsonWriter.writeArrayField("upgrades", upgrades(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("compatibleWith", compatibleWith(), (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MeshUpgradeProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MeshUpgradeProfileProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MeshUpgradeProfileProperties.
     */
    public static MeshUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MeshUpgradeProfileProperties deserializedMeshUpgradeProfileProperties = new MeshUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("revision".equals(fieldName)) {
                    deserializedMeshUpgradeProfileProperties.withRevision(reader.getString());
                } else if ("upgrades".equals(fieldName)) {
                    List<String> upgrades = reader.readArray(reader1 -> reader1.getString());
                    deserializedMeshUpgradeProfileProperties.withUpgrades(upgrades);
                } else if ("compatibleWith".equals(fieldName)) {
                    List<CompatibleVersions> compatibleWith
                        = reader.readArray(reader1 -> CompatibleVersions.fromJson(reader1));
                    deserializedMeshUpgradeProfileProperties.withCompatibleWith(compatibleWith);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMeshUpgradeProfileProperties;
        });
    }
}
