/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.TrustedAccessRoleBindingProperties;
import com.azure.resourcemanager.containerservice.models.TrustedAccessRoleBindingProvisioningState;
import java.io.IOException;
import java.util.List;

public final class TrustedAccessRoleBindingInner
extends ProxyResource {
    private TrustedAccessRoleBindingProperties innerProperties = new TrustedAccessRoleBindingProperties();
    private SystemData systemData;
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(TrustedAccessRoleBindingInner.class);

    private TrustedAccessRoleBindingProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public TrustedAccessRoleBindingProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String sourceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceResourceId();
    }

    public TrustedAccessRoleBindingInner withSourceResourceId(String sourceResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrustedAccessRoleBindingProperties();
        }
        this.innerProperties().withSourceResourceId(sourceResourceId);
        return this;
    }

    public List<String> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    public TrustedAccessRoleBindingInner withRoles(List<String> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrustedAccessRoleBindingProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model TrustedAccessRoleBindingInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TrustedAccessRoleBindingInner fromJson(JsonReader jsonReader) throws IOException {
        return (TrustedAccessRoleBindingInner)((Object)jsonReader.readObject(reader -> {
            TrustedAccessRoleBindingInner deserializedTrustedAccessRoleBindingInner = new TrustedAccessRoleBindingInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.innerProperties = TrustedAccessRoleBindingProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrustedAccessRoleBindingInner;
        }));
    }
}

